/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.lang;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.JoinConfiguration;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.minimessage.Template;
import io.github.pronze.lib.kyori.adventure.text.minimessage.template.TemplateResolver;
import io.github.pronze.lib.kyori.adventure.title.Title;
import io.github.pronze.lib.screaminglib.lang.Lang;
import io.github.pronze.lib.screaminglib.lang.LangService;
import io.github.pronze.lib.screaminglib.lang.Messageable;
import io.github.pronze.lib.screaminglib.lang.StringMessageable;
import io.github.pronze.lib.screaminglib.lang.SupplierStringMessageable;
import io.github.pronze.lib.screaminglib.lang.Translation;
import io.github.pronze.lib.screaminglib.lang.container.TranslationContainer;
import io.github.pronze.lib.screaminglib.placeholders.PlaceholderManager;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.sender.MultiPlatformOfflinePlayer;
import io.github.pronze.lib.screaminglib.sender.TitleableSenderMessage;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Message
implements TitleableSenderMessage,
Cloneable {
    private static final Pattern LEGACY_PLACEHOLDERS = Pattern.compile("[%]([^%]+)[%]");
    private static final Pattern EARLY_MINI_MESSAGE_PLACEHOLDERS = Pattern.compile("[<]([^>]+)[>]");
    private final List<Messageable> translations = new LinkedList<Messageable>();
    private final Map<String, Function<CommandSenderWrapper, Component>> placeholders = new HashMap<String, Function<CommandSenderWrapper, Component>>();
    private final Map<String, String> earlyPlaceholders = new HashMap<String, String>();
    private final LangService langService;
    @NotNull
    private Component prefix;
    @Nullable
    private Title.Times times;
    private PrefixPolicy prefixPolicy = PrefixPolicy.ALL_MESSAGES;
    private PrefixResolving prefixResolving = PrefixResolving.DEFAULT;

    public <M extends Messageable> Message(Collection<M> translations, LangService langService, @NotNull Component prefix) {
        this.translations.addAll(translations);
        this.langService = langService;
        this.prefix = prefix;
    }

    @NotNull
    public static Message empty() {
        return new Message(List.of(), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message empty(@NotNull Component prefix) {
        return new Message(List.of(), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message empty(@NotNull ComponentLike prefix) {
        return new Message(List.of(), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message empty(@NotNull LangService service) {
        return new Message(List.of(), service, Component.empty());
    }

    @NotNull
    public static Message empty(@NotNull LangService service, @NotNull Component prefix) {
        return new Message(List.of(), service, prefix);
    }

    @NotNull
    public static Message empty(@NotNull LangService service, @NotNull ComponentLike prefix) {
        return new Message(List.of(), service, prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull String message) {
        return new Message(List.of(StringMessageable.of(message)), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message ofPlainText(String ... messages) {
        return new Message(List.of(StringMessageable.of(messages)), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull List<String> messages) {
        return new Message(List.of(StringMessageable.of(messages)), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull Component prefix, @NotNull String message) {
        return new Message(List.of(StringMessageable.of(message)), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull ComponentLike prefix, @NotNull String message) {
        return new Message(List.of(StringMessageable.of(message)), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull Component prefix, String ... messages) {
        return new Message(List.of(StringMessageable.of(messages)), Lang.getDefaultService(), prefix);
    }

    public static Message ofPlainText(ComponentLike prefix, String ... messages) {
        return new Message(List.of(StringMessageable.of(messages)), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull Component prefix, @NotNull List<String> messages) {
        return new Message(List.of(StringMessageable.of(messages)), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull ComponentLike prefix, @NotNull List<String> messages) {
        return new Message(List.of(StringMessageable.of(messages)), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull String message) {
        return new Message(List.of(StringMessageable.of(message)), service, Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, String ... messages) {
        return new Message(List.of(StringMessageable.of(messages)), service, Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull List<String> messages) {
        return new Message(List.of(StringMessageable.of(messages)), service, Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull Component prefix, @NotNull String message) {
        return new Message(List.of(StringMessageable.of(message)), service, prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull ComponentLike prefix, @NotNull String message) {
        return new Message(List.of(StringMessageable.of(message)), service, prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull Component prefix, String ... messages) {
        return new Message(List.of(StringMessageable.of(messages)), service, prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull ComponentLike prefix, String ... messages) {
        return new Message(List.of(StringMessageable.of(messages)), service, prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull Component prefix, @NotNull List<String> messages) {
        return new Message(List.of(StringMessageable.of(messages)), service, prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull ComponentLike prefix, @NotNull List<String> messages) {
        return new Message(List.of(StringMessageable.of(messages)), service, prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull Supplier<List<String>> message) {
        return new Message(List.of(SupplierStringMessageable.of(message)), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull Component prefix, @NotNull Supplier<List<String>> message) {
        return new Message(List.of(SupplierStringMessageable.of(message)), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull ComponentLike prefix, @NotNull Supplier<List<String>> message) {
        return new Message(List.of(SupplierStringMessageable.of(message)), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull Supplier<List<String>> message) {
        return new Message(List.of(SupplierStringMessageable.of(message)), service, Component.empty());
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull Component prefix, @NotNull Supplier<List<String>> message) {
        return new Message(List.of(SupplierStringMessageable.of(message)), service, prefix);
    }

    @NotNull
    public static Message ofPlainText(@NotNull LangService service, @NotNull ComponentLike prefix, @NotNull Supplier<List<String>> message) {
        return new Message(List.of(SupplierStringMessageable.of(message)), service, prefix.asComponent());
    }

    @NotNull
    public static Message of(String ... key) {
        return new Message(List.of(Translation.of(key)), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message of(@NotNull Translation translation) {
        return new Message(List.of(translation), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static <M extends Messageable> Message of(@NotNull List<M> translations) {
        return new Message(translations, Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message of(@NotNull LangService service, String ... key) {
        return new Message(List.of(Translation.of(key)), service, Component.empty());
    }

    public static Message of(LangService service, Translation translation) {
        return new Message(List.of(translation), service, Component.empty());
    }

    @NotNull
    public static <M extends Messageable> Message of(@NotNull LangService service, @NotNull List<M> translations) {
        return new Message(translations, service, Component.empty());
    }

    @NotNull
    public static Message of(@NotNull Component prefix, String ... key) {
        return new Message(List.of(Translation.of(key)), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message of(@NotNull ComponentLike prefix, String ... key) {
        return new Message(List.of(Translation.of(key)), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message of(@NotNull Component prefix, @NotNull Messageable translation) {
        return new Message(List.of(translation), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message of(@NotNull ComponentLike prefix, @NotNull Messageable translation) {
        return new Message(List.of(translation), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static <M extends Messageable> Message of(@NotNull Component prefix, @NotNull List<M> translations) {
        return new Message(translations, Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static <M extends Messageable> Message of(@NotNull ComponentLike prefix, @NotNull List<M> translations) {
        return new Message(translations, Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull Component prefix, String ... key) {
        return new Message(List.of(Translation.of(key)), service, prefix);
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull ComponentLike prefix, String ... key) {
        return new Message(List.of(Translation.of(key)), service, prefix.asComponent());
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull Component prefix, @NotNull Messageable translation) {
        return new Message(List.of(translation), service, prefix);
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull ComponentLike prefix, @NotNull Messageable translation) {
        return new Message(List.of(translation), service, prefix.asComponent());
    }

    @NotNull
    public static <M extends Messageable> Message of(@NotNull LangService service, @NotNull Component prefix, @NotNull List<M> translations) {
        return new Message(translations, service, prefix);
    }

    @NotNull
    public static <M extends Messageable> Message of(@NotNull LangService service, @NotNull ComponentLike prefix, @NotNull List<M> translations) {
        return new Message(translations, service, prefix.asComponent());
    }

    @NotNull
    public static Message of(@NotNull Collection<String> key) {
        return new Message(List.of(Translation.of(key)), Lang.getDefaultService(), Component.empty());
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull Collection<String> key) {
        return new Message(List.of(Translation.of(key)), service, Component.empty());
    }

    @NotNull
    public static Message of(@NotNull Component prefix, @NotNull Collection<String> key) {
        return new Message(List.of(Translation.of(key)), Lang.getDefaultService(), prefix);
    }

    @NotNull
    public static Message of(@NotNull ComponentLike prefix, @NotNull Collection<String> key) {
        return new Message(List.of(Translation.of(key)), Lang.getDefaultService(), prefix.asComponent());
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull Component prefix, @NotNull Collection<String> key) {
        return new Message(List.of(Translation.of(key)), service, prefix);
    }

    @NotNull
    public static Message of(@NotNull LangService service, @NotNull ComponentLike prefix, @NotNull Collection<String> key) {
        return new Message(List.of(Translation.of(key)), service, prefix.asComponent());
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, byte value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, short value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, int value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, long value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, char value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, boolean value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, double value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, float value) {
        return this.placeholder(placeholder, Component.text(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, double value, int round) {
        double pow = Math.pow(10.0, round);
        return this.placeholder(placeholder, Component.text((double)Math.round(value * pow) / pow));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, float value, int round) {
        double pow = Math.pow(10.0, round);
        return this.placeholder(placeholder, Component.text((double)Math.round((double)value * pow) / pow));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, @NotNull String value) {
        return this.placeholder(placeholder, Lang.MINIMESSAGE.parse(value));
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, @NotNull Component component) {
        this.placeholders.put(placeholder, sender -> component);
        return this;
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, @NotNull ComponentLike component) {
        return this.placeholder(placeholder, component.asComponent());
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, @NotNull Translation translation) {
        Message msg = Message.of(translation);
        this.placeholders.put(placeholder, msg::getForJoined);
        return this;
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, @NotNull Message message) {
        this.placeholders.put(placeholder, message::getForJoined);
        return this;
    }

    @NotNull
    public Message placeholder(@NotNull String placeholder, @NotNull Function<CommandSenderWrapper, Component> componentFunction) {
        this.placeholders.put(placeholder, componentFunction);
        return this;
    }

    @NotNull
    public Message earlyPlaceholder(@NotNull String placeholder, @NotNull Component value) {
        this.earlyPlaceholders.put(placeholder, (String)Lang.MINIMESSAGE.serialize(value));
        return this;
    }

    @NotNull
    public Message earlyPlaceholder(@NotNull String placeholder, @NotNull String value) {
        this.earlyPlaceholders.put(placeholder, value);
        return this;
    }

    @NotNull
    public Message prefix(@Nullable Component prefix) {
        if (prefix == null) {
            return this.noPrefix();
        }
        this.prefix = prefix;
        return this;
    }

    @NotNull
    public Message prefix(ComponentLike prefix) {
        if (prefix == null) {
            return this.noPrefix();
        }
        this.prefix = prefix.asComponent();
        return this;
    }

    @NotNull
    public Message prefixOrDefault(Component prefix) {
        if (prefix == null || Component.empty().equals(prefix)) {
            return this.defaultPrefix();
        }
        this.prefix = prefix;
        return this;
    }

    @NotNull
    public Message prefixOrDefault(ComponentLike prefix) {
        if (prefix == null || Component.empty().equals(prefix.asComponent())) {
            return this.defaultPrefix();
        }
        this.prefix = prefix.asComponent();
        return this;
    }

    @NotNull
    public Message noPrefix() {
        this.prefix = Component.empty();
        return this;
    }

    @NotNull
    public Message defaultPrefix() {
        this.prefix = Lang.getDefaultService().getDefaultPrefix();
        return this;
    }

    @NotNull
    public Message resolvePrefix() {
        this.prefixResolving = PrefixResolving.PER_PLAYER;
        return this;
    }

    @NotNull
    public Message prefixPolicy(PrefixPolicy prefixPolicy) {
        this.prefixPolicy = prefixPolicy;
        return this;
    }

    @NotNull
    public Message prefixResolving(PrefixResolving resolving) {
        this.prefixResolving = resolving;
        return this;
    }

    @NotNull
    public Message join(@NotNull String key) {
        this.translations.add(Translation.of(key));
        return this;
    }

    @NotNull
    public Message join(String ... keys) {
        this.translations.add(Translation.of(keys));
        return this;
    }

    @NotNull
    public Message join(Collection<String> keys) {
        this.translations.add(Translation.of(keys));
        return this;
    }

    @NotNull
    public Message joinPlainText(String message) {
        this.translations.add(StringMessageable.of(message));
        return this;
    }

    @NotNull
    public Message joinPlainText(List<String> messages) {
        this.translations.add(StringMessageable.of(messages));
        return this;
    }

    @NotNull
    public Message joinPlainText(Supplier<List<String>> messages) {
        this.translations.add(SupplierStringMessageable.of(messages));
        return this;
    }

    @NotNull
    public Message join(Messageable translation) {
        this.translations.add(translation);
        return this;
    }

    @NotNull
    public <M extends Messageable> Message join(List<M> translations) {
        this.translations.addAll(translations);
        return this;
    }

    @NotNull
    public Message times(Title.Times times) {
        this.times = times;
        return this;
    }

    @NotNull
    public List<Component> getFor(CommandSenderWrapper sender) {
        AtomicBoolean prefixSetter = new AtomicBoolean(true);
        TranslationContainer container = this.langService.getFor(sender);
        if (this.prefixResolving == PrefixResolving.PER_PLAYER) {
            this.prefix = this.langService.resolvePrefix(sender);
        }
        return this.translations.stream().map(translation -> {
            List list = translation.translateIfNeeded(container).stream().map(s -> {
                StringBuilder output;
                int lastIndex;
                Matcher matcher;
                if (PlaceholderManager.isInitialized()) {
                    matcher = LEGACY_PLACEHOLDERS.matcher((CharSequence)s);
                    lastIndex = 0;
                    output = new StringBuilder();
                    while (matcher.find()) {
                        output.append((CharSequence)s, lastIndex, matcher.start());
                        String result = PlaceholderManager.resolveString(sender instanceof MultiPlatformOfflinePlayer ? (MultiPlatformOfflinePlayer)((Object)sender) : null, "%" + matcher.group(1) + "%");
                        if (translation.getType() == Messageable.Type.ADVENTURE) {
                            output.append((String)Lang.MINIMESSAGE.serialize(AdventureHelper.toComponent(result)));
                        } else {
                            output.append(result);
                        }
                        lastIndex = matcher.end();
                    }
                    if (lastIndex < s.length()) {
                        output.append((CharSequence)s, lastIndex, s.length());
                    }
                    s = output.toString();
                }
                if (translation.getType() == Messageable.Type.ADVENTURE) {
                    if (!this.earlyPlaceholders.isEmpty()) {
                        matcher = EARLY_MINI_MESSAGE_PLACEHOLDERS.matcher((CharSequence)s);
                        lastIndex = 0;
                        output = new StringBuilder();
                        while (matcher.find()) {
                            output.append((CharSequence)s, lastIndex, matcher.start());
                            if (this.earlyPlaceholders.containsKey(matcher.group(1))) {
                                output.append(this.earlyPlaceholders.get(matcher.group(1)));
                            } else {
                                output.append("<").append(matcher.group(1)).append(">");
                            }
                            lastIndex = matcher.end();
                        }
                        if (lastIndex < s.length()) {
                            output.append((CharSequence)s, lastIndex, s.length());
                        }
                        s = output.toString();
                    }
                    TemplateResolver resolvedTemplates = TemplateResolver.templates(this.placeholders.entrySet().stream().map(entry -> Template.template((String)entry.getKey(), (ComponentLike)((Function)entry.getValue()).apply(sender))).collect(Collectors.toList()));
                    return Lang.MINIMESSAGE.deserialize((String)s, resolvedTemplates);
                }
                matcher = LEGACY_PLACEHOLDERS.matcher((CharSequence)s);
                lastIndex = 0;
                output = new StringBuilder();
                while (matcher.find()) {
                    output.append((CharSequence)s, lastIndex, matcher.start());
                    if (this.placeholders.containsKey(matcher.group(1))) {
                        output.append(AdventureHelper.toLegacy(this.placeholders.get(matcher.group(1)).apply(sender)));
                    } else {
                        output.append("%").append(matcher.group(1)).append("%");
                    }
                    lastIndex = matcher.end();
                }
                if (lastIndex < s.length()) {
                    output.append((CharSequence)s, lastIndex, s.length());
                }
                return AdventureHelper.toComponent(output.toString());
            }).map(component -> {
                if (!Component.empty().equals(this.prefix) && (this.prefixPolicy != PrefixPolicy.FIRST_MESSAGE || prefixSetter.get())) {
                    prefixSetter.set(false);
                    return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.prefix)).append((Component)Component.space())).append((Component)component)).build();
                }
                return component;
            }).collect(Collectors.toList());
            if (list.isEmpty()) {
                return List.of(translation.getFallback());
            }
            return list;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @NotNull
    public Component getForJoined(CommandSenderWrapper sender) {
        return Component.join(JoinConfiguration.separator(Component.newline()), this.getFor(sender));
    }

    @NotNull
    public List<Component> getForAnyone() {
        return this.getFor(null);
    }

    public Component getForAnyoneJoined() {
        return Component.join(JoinConfiguration.separator(Component.newline()), this.getForAnyone());
    }

    public <W extends CommandSenderWrapper> Message title(W sender) {
        sender.showTitle(this.asTitle(sender));
        return this;
    }

    public <W extends CommandSenderWrapper> Message title(W ... senders) {
        for (W sender : senders) {
            this.title(sender);
        }
        return this;
    }

    public <W extends CommandSenderWrapper> Message title(Collection<W> senders) {
        senders.forEach(this::title);
        return this;
    }

    public <W extends CommandSenderWrapper> Tasker.TaskBuilder titleTask(W sender) {
        return Tasker.build(() -> sender.showTitle(this.asTitle(sender)));
    }

    public <W extends CommandSenderWrapper> Tasker.TaskBuilder titleTask(W ... senders) {
        return Tasker.build(() -> {
            for (CommandSenderWrapper sender : senders) {
                this.title(sender);
            }
        });
    }

    public <W extends CommandSenderWrapper> Tasker.TaskBuilder titleTask(Collection<W> senders) {
        return Tasker.build(() -> senders.forEach(this::title));
    }

    public <W extends CommandSenderWrapper> Message titleAsync(W sender) {
        this.titleTask(sender).async().start();
        return this;
    }

    public <W extends CommandSenderWrapper> Message titleAsync(W ... senders) {
        this.titleTask((W)senders).async().start();
        return this;
    }

    public <W extends CommandSenderWrapper> Message titleAsync(Collection<W> receivers) {
        this.titleTask(receivers).async().start();
        return this;
    }

    public <W extends CommandSenderWrapper> Message send(W receiver) {
        this.getFor(receiver).forEach(receiver::sendMessage);
        return this;
    }

    public <W extends CommandSenderWrapper> Message send(W ... receivers) {
        for (W sender : receivers) {
            this.send(sender);
        }
        return this;
    }

    public <W extends CommandSenderWrapper> Message send(Collection<W> receivers) {
        receivers.forEach(this::send);
        return this;
    }

    public <W extends CommandSenderWrapper> Tasker.TaskBuilder sendTask(W receiver) {
        return Tasker.build(() -> this.getFor(receiver).forEach(receiver::sendMessage));
    }

    public <W extends CommandSenderWrapper> Tasker.TaskBuilder sendTask(W ... receivers) {
        return Tasker.build(() -> {
            for (CommandSenderWrapper sender : receivers) {
                this.send(sender);
            }
        });
    }

    public <W extends CommandSenderWrapper> Tasker.TaskBuilder sendTask(Collection<W> receivers) {
        return Tasker.build(() -> receivers.forEach(this::send));
    }

    public <W extends CommandSenderWrapper> Message sendAsync(W receiver) {
        this.sendTask(receiver).async().start();
        return this;
    }

    public <W extends CommandSenderWrapper> Message sendAsync(W ... receivers) {
        this.sendTask((W)receivers).async().start();
        return this;
    }

    public <W extends CommandSenderWrapper> Message sendAsync(Collection<W> receivers) {
        this.sendTask(receivers).async().start();
        return this;
    }

    @Override
    @NotNull
    public Component asComponent(@Nullable CommandSenderWrapper sender) {
        return this.getForJoined(sender);
    }

    @Override
    @NotNull
    public List<Component> asComponentList(@Nullable CommandSenderWrapper wrapper) {
        return this.getFor(wrapper);
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.getForAnyoneJoined();
    }

    @Override
    @NotNull
    public Title asTitle(@Nullable CommandSenderWrapper sender, @Nullable Title.Times times) {
        List<Component> messages = this.getFor(sender);
        return Title.title(messages.size() >= 1 ? messages.get(0) : Component.empty(), messages.size() >= 2 ? messages.get(1) : Component.empty(), times);
    }

    @Override
    @NotNull
    public Title asTitle(@Nullable CommandSenderWrapper sender) {
        return this.asTitle(sender, this.times);
    }

    @Override
    @NotNull
    public Title asTitle(@Nullable Title.Times times) {
        return this.asTitle(null, times);
    }

    @Override
    @NotNull
    public Title asTitle() {
        return this.asTitle(null, this.times);
    }

    public Message clone() {
        Message msg = new Message(this.translations, this.langService, this.prefix);
        msg.times = this.times;
        msg.placeholders.putAll(this.placeholders);
        msg.prefixPolicy = this.prefixPolicy;
        return msg;
    }

    public List<Messageable> getTranslations() {
        return this.translations;
    }

    public Map<String, Function<CommandSenderWrapper, Component>> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, String> getEarlyPlaceholders() {
        return this.earlyPlaceholders;
    }

    public LangService getLangService() {
        return this.langService;
    }

    @NotNull
    public Component getPrefix() {
        return this.prefix;
    }

    @Nullable
    public Title.Times getTimes() {
        return this.times;
    }

    public PrefixPolicy getPrefixPolicy() {
        return this.prefixPolicy;
    }

    public PrefixResolving getPrefixResolving() {
        return this.prefixResolving;
    }

    public void setPrefix(@NotNull Component prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.prefix = prefix;
    }

    public void setTimes(@Nullable Title.Times times) {
        this.times = times;
    }

    public void setPrefixPolicy(PrefixPolicy prefixPolicy) {
        this.prefixPolicy = prefixPolicy;
    }

    public void setPrefixResolving(PrefixResolving prefixResolving) {
        this.prefixResolving = prefixResolving;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Messageable> this$translations = this.getTranslations();
        List<Messageable> other$translations = other.getTranslations();
        if (this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations)) {
            return false;
        }
        Map<String, Function<CommandSenderWrapper, Component>> this$placeholders = this.getPlaceholders();
        Map<String, Function<CommandSenderWrapper, Component>> other$placeholders = other.getPlaceholders();
        if (this$placeholders == null ? other$placeholders != null : !((Object)this$placeholders).equals(other$placeholders)) {
            return false;
        }
        Map<String, String> this$earlyPlaceholders = this.getEarlyPlaceholders();
        Map<String, String> other$earlyPlaceholders = other.getEarlyPlaceholders();
        if (this$earlyPlaceholders == null ? other$earlyPlaceholders != null : !((Object)this$earlyPlaceholders).equals(other$earlyPlaceholders)) {
            return false;
        }
        LangService this$langService = this.getLangService();
        LangService other$langService = other.getLangService();
        if (this$langService == null ? other$langService != null : !this$langService.equals(other$langService)) {
            return false;
        }
        Component this$prefix = this.getPrefix();
        Component other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Title.Times this$times = this.getTimes();
        Title.Times other$times = other.getTimes();
        if (this$times == null ? other$times != null : !this$times.equals(other$times)) {
            return false;
        }
        PrefixPolicy this$prefixPolicy = this.getPrefixPolicy();
        PrefixPolicy other$prefixPolicy = other.getPrefixPolicy();
        if (this$prefixPolicy == null ? other$prefixPolicy != null : !((Object)((Object)this$prefixPolicy)).equals((Object)other$prefixPolicy)) {
            return false;
        }
        PrefixResolving this$prefixResolving = this.getPrefixResolving();
        PrefixResolving other$prefixResolving = other.getPrefixResolving();
        return !(this$prefixResolving == null ? other$prefixResolving != null : !((Object)((Object)this$prefixResolving)).equals((Object)other$prefixResolving));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Messageable> $translations = this.getTranslations();
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        Map<String, Function<CommandSenderWrapper, Component>> $placeholders = this.getPlaceholders();
        result = result * 59 + ($placeholders == null ? 43 : ((Object)$placeholders).hashCode());
        Map<String, String> $earlyPlaceholders = this.getEarlyPlaceholders();
        result = result * 59 + ($earlyPlaceholders == null ? 43 : ((Object)$earlyPlaceholders).hashCode());
        LangService $langService = this.getLangService();
        result = result * 59 + ($langService == null ? 43 : $langService.hashCode());
        Component $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Title.Times $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : $times.hashCode());
        PrefixPolicy $prefixPolicy = this.getPrefixPolicy();
        result = result * 59 + ($prefixPolicy == null ? 43 : ((Object)((Object)$prefixPolicy)).hashCode());
        PrefixResolving $prefixResolving = this.getPrefixResolving();
        result = result * 59 + ($prefixResolving == null ? 43 : ((Object)((Object)$prefixResolving)).hashCode());
        return result;
    }

    public String toString() {
        return "Message(translations=" + this.getTranslations() + ", placeholders=" + this.getPlaceholders() + ", earlyPlaceholders=" + this.getEarlyPlaceholders() + ", langService=" + this.getLangService() + ", prefix=" + this.getPrefix() + ", times=" + this.getTimes() + ", prefixPolicy=" + this.getPrefixPolicy() + ", prefixResolving=" + this.getPrefixResolving() + ")";
    }

    public static enum PrefixPolicy {
        ALL_MESSAGES,
        FIRST_MESSAGE;

    }

    public static enum PrefixResolving {
        DEFAULT,
        PER_PLAYER;

    }
}

