/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.lang;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.screaminglib.lang.Messageable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class Translation
implements Messageable {
    private final List<String> keys = new LinkedList<String>();
    private final Component fallback;

    private Translation(Collection<String> keys, Component fallback) {
        this.keys.addAll(keys);
        this.fallback = fallback;
    }

    public static Translation of(String ... keys) {
        return Translation.of(Arrays.asList(keys), Component.text(String.join((CharSequence)".", keys)).color(NamedTextColor.RED));
    }

    public static Translation of(Collection<String> keys) {
        return Translation.of(keys, Component.text(String.join((CharSequence)".", keys)).color(NamedTextColor.RED));
    }

    public static Translation of(Collection<String> keys, Component fallback) {
        return new Translation(keys, fallback);
    }

    public static Translation of(Collection<String> keys, ComponentLike fallback) {
        return new Translation(keys, fallback.asComponent());
    }

    public Translation join(String ... key) {
        LinkedList<String> copied = new LinkedList<String>(this.keys);
        copied.addAll(Arrays.asList(key));
        return Translation.of(copied);
    }

    public Translation join(Collection<String> keys) {
        LinkedList<String> copied = new LinkedList<String>(this.keys);
        copied.addAll(keys);
        return Translation.of(copied, Component.text(String.join((CharSequence)".", keys)).color(NamedTextColor.RED));
    }

    public Translation join(Collection<String> keys, Component fallback) {
        LinkedList<String> copied = new LinkedList<String>(this.keys);
        copied.addAll(keys);
        return Translation.of(copied, fallback);
    }

    public Translation join(Collection<String> keys, ComponentLike fallback) {
        LinkedList<String> copied = new LinkedList<String>(this.keys);
        copied.addAll(keys);
        return Translation.of(copied, fallback);
    }

    @Override
    public boolean needsTranslation() {
        return true;
    }

    @Override
    public Messageable.Type getType() {
        return Messageable.Type.ADVENTURE;
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    @Override
    public Component getFallback() {
        return this.fallback;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Translation)) {
            return false;
        }
        Translation other = (Translation)o;
        List<String> this$keys = this.getKeys();
        List<String> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        Component this$fallback = this.getFallback();
        Component other$fallback = other.getFallback();
        return !(this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        Component $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
        return result;
    }

    public String toString() {
        return "Translation(keys=" + this.getKeys() + ", fallback=" + this.getFallback() + ")";
    }
}

