/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.lang.container;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.screaminglib.lang.container.TranslationContainer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

class TranslationContainerImpl
implements TranslationContainer {
    static final TranslationContainer EMPTY = new TranslationContainerImpl(BasicConfigurationNode.root(), null);
    private ConfigurationNode node;
    @Nullable
    private TranslationContainer fallbackContainer;

    @Override
    public List<String> translate(Collection<String> key) {
        return this.translate((String[])key.toArray(String[]::new));
    }

    @Override
    public List<String> translate(String ... key) {
        ConfigurationNode node = this.node.node(key);
        if (node.isList()) {
            return node.childrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
        }
        if (!node.empty()) {
            return List.of(node.getString(""));
        }
        return this.fallbackContainer != null ? this.fallbackContainer.translate(key) : List.of();
    }

    @Override
    public boolean isEmpty() {
        return this.node.empty();
    }

    @Override
    public ConfigurationNode getNode() {
        return this.node;
    }

    @Override
    @Nullable
    public TranslationContainer getFallbackContainer() {
        return this.fallbackContainer;
    }

    @Override
    public void setNode(ConfigurationNode node) {
        this.node = node;
    }

    @Override
    public void setFallbackContainer(@Nullable TranslationContainer fallbackContainer) {
        this.fallbackContainer = fallbackContainer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationContainerImpl)) {
            return false;
        }
        TranslationContainerImpl other = (TranslationContainerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigurationNode this$node = this.getNode();
        ConfigurationNode other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        TranslationContainer this$fallbackContainer = this.getFallbackContainer();
        TranslationContainer other$fallbackContainer = other.getFallbackContainer();
        return !(this$fallbackContainer == null ? other$fallbackContainer != null : !this$fallbackContainer.equals(other$fallbackContainer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationContainerImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigurationNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        TranslationContainer $fallbackContainer = this.getFallbackContainer();
        result = result * 59 + ($fallbackContainer == null ? 43 : $fallbackContainer.hashCode());
        return result;
    }

    public String toString() {
        return "TranslationContainerImpl(node=" + this.getNode() + ", fallbackContainer=" + this.getFallbackContainer() + ")";
    }

    public TranslationContainerImpl(ConfigurationNode node, @Nullable TranslationContainer fallbackContainer) {
        this.node = node;
        this.fallbackContainer = fallbackContainer;
    }
}

