/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.npc;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.hologram.Hologram;
import io.github.pronze.lib.screaminglib.hologram.HologramManager;
import io.github.pronze.lib.screaminglib.npc.NPC;
import io.github.pronze.lib.screaminglib.npc.NPCManager;
import io.github.pronze.lib.screaminglib.npc.skin.NPCSkin;
import io.github.pronze.lib.screaminglib.npc.skin.SkinLayerValues;
import io.github.pronze.lib.screaminglib.packet.MetadataItem;
import io.github.pronze.lib.screaminglib.packet.SClientboundAddPlayerPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundMoveEntityPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundPlayerInfoPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundRemoveEntitiesPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundRotateHeadPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetPlayerTeamPacket;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.player.gamemode.GameModeHolder;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.ProxyType;
import io.github.pronze.lib.screaminglib.utils.visual.TextEntry;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractTouchableVisual;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;

public class NPCImpl
extends AbstractTouchableVisual<NPC>
implements NPC {
    private static final GameModeHolder GAME_MODE = GameModeHolder.of("SURVIVAL");
    private static final boolean IS_BUNGEE = Server.getProxyType() == ProxyType.BUNGEE;
    private final int entityId;
    private final Hologram hologram;
    private Component tabListName;
    private final List<SClientboundPlayerInfoPacket.Property> properties;
    private NPCSkin skin;
    private volatile boolean lookAtPlayer;
    private final List<MetadataItem> metadata;
    private SClientboundSetPlayerTeamPacket.CollisionRule collisionRule;

    public NPCImpl(UUID uuid, LocationHolder location, boolean touchable) {
        super(uuid, location, touchable);
        if (!Server.isServerThread()) {
            try {
                this.entityId = EntityMapper.getNewEntityIdSynchronously().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.entityId = EntityMapper.getNewEntityId();
        }
        this.lookAtPlayer = false;
        this.tabListName = AdventureHelper.toComponent("[NPC] " + uuid.toString().replace("-", "").substring(0, 10));
        this.hologram = HologramManager.hologram(location.clone().add(0.0, 1.5, 0.0));
        this.metadata = new ArrayList<MetadataItem>();
        this.properties = new ArrayList<SClientboundPlayerInfoPacket.Property>();
        this.collisionRule = SClientboundSetPlayerTeamPacket.CollisionRule.ALWAYS;
        this.metadata.add(MetadataItem.of((byte)SkinLayerValues.findLayerByVersion(), (byte)127));
    }

    @Override
    @Nullable
    public List<TextEntry> displayName() {
        return List.copyOf(this.hologram.lines().values());
    }

    @Override
    public NPC displayName(List<Component> name) {
        this.hologram.setLines(name);
        return this;
    }

    @Override
    public NPC skin(NPCSkin skin) {
        if (!this.shown()) {
            this.skin = skin;
            this.properties.removeIf(property -> property.name().equals("textures"));
            if (skin == null) {
                return this;
            }
            this.properties.add(new SClientboundPlayerInfoPacket.Property("textures", skin.getValue(), skin.getSignature()));
            return this;
        }
        SClientboundPlayerInfoPacket playerInfoPacket = new SClientboundPlayerInfoPacket().action(SClientboundPlayerInfoPacket.Action.REMOVE_PLAYER).data(this.getNPCInfoData());
        this.viewers().forEach(playerInfoPacket::sendPacket);
        this.viewers().forEach(this.getFullDestroyPacket()::sendPacket);
        this.skin = skin;
        this.properties.removeIf(property -> property.name().equals("textures"));
        if (skin == null) {
            return this;
        }
        this.properties.add(new SClientboundPlayerInfoPacket.Property("textures", skin.getValue(), skin.getSignature()));
        playerInfoPacket.action(SClientboundPlayerInfoPacket.Action.ADD_PLAYER);
        playerInfoPacket.data(this.getNPCInfoData());
        this.viewers().forEach(playerInfoPacket::sendPacket);
        this.viewers().forEach(this::sendSpawnPackets);
        Tasker.build(() -> {
            playerInfoPacket.action(SClientboundPlayerInfoPacket.Action.REMOVE_PLAYER);
            playerInfoPacket.data(this.getNPCInfoData());
            this.viewers().forEach(playerInfoPacket::sendPacket);
        }).delay(6L, TaskerTime.SECONDS).start();
        return this;
    }

    @Override
    public void lookAtLocation(LocationHolder location, PlayerWrapper player) {
        LocationHolder direction = this.location().setDirection(player.getLocation().subtract(this.location()).asVector());
        new SClientboundMoveEntityPacket.Rot().entityId(this.entityId()).yaw((byte)(direction.getYaw() * 256.0f / 360.0f)).pitch((byte)(direction.getPitch() * 256.0f / 360.0f)).onGround(true).sendPacket(player);
        new SClientboundRotateHeadPacket().entityId(this.entityId()).headYaw(direction.getYaw()).sendPacket(player);
    }

    @Override
    public boolean hasId(int entityId) {
        return this.entityId == entityId;
    }

    @Override
    public NPC update() {
        if (this.created()) {
            // empty if block
        }
        return this;
    }

    @Override
    public NPC show() {
        if (this.visible) {
            return this;
        }
        if (this.destroyed()) {
            throw new UnsupportedOperationException("Cannot call NPC#show() for destroyed npcs!");
        }
        this.visible = true;
        this.hologram.show();
        this.viewers.forEach(viewer -> this.onViewerAdded((PlayerWrapper)viewer, false));
        return this;
    }

    @Override
    public NPC hide() {
        if (!this.visible) {
            return this;
        }
        this.visible = false;
        this.hologram.hide();
        this.viewers.forEach(viewer -> this.onViewerRemoved((PlayerWrapper)viewer, false));
        return this;
    }

    @Override
    public NPC title(Component title) {
        this.hologram.title(title);
        return this;
    }

    @Override
    public NPC title(ComponentLike title) {
        this.hologram.title(title);
        return null;
    }

    @Override
    public void onViewerAdded(PlayerWrapper player, boolean checkDistance) {
        if (!player.isOnline()) {
            return;
        }
        this.hologram.addViewer(player);
        this.sendSpawnPackets(player);
    }

    @Override
    public void onViewerRemoved(PlayerWrapper player, boolean checkDistance) {
        if (!player.isOnline()) {
            return;
        }
        this.hologram.removeViewer(player);
        this.getFullDestroyPacket().sendPacket(player);
        new SClientboundPlayerInfoPacket().action(SClientboundPlayerInfoPacket.Action.REMOVE_PLAYER).data(this.getNPCInfoData()).sendPacket(player);
        new SClientboundSetPlayerTeamPacket().teamKey(AdventureHelper.toLegacy(this.tabListName)).mode(SClientboundSetPlayerTeamPacket.Mode.REMOVE).displayName(this.tabListName).collisionRule(this.collisionRule).tagVisibility(SClientboundSetPlayerTeamPacket.TagVisibility.NEVER).teamColor(NamedTextColor.BLACK).teamPrefix(Component.empty()).teamSuffix(Component.empty()).friendlyFire(false).seeInvisible(true).entities(Collections.singletonList(AdventureHelper.toLegacy(this.tabListName))).sendPacket(player);
    }

    @Override
    public NPC spawn() {
        this.show();
        return this;
    }

    @Override
    public void destroy() {
        if (this.destroyed()) {
            return;
        }
        super.destroy();
        this.hide();
        this.viewers.clear();
        this.hologram.destroy();
        NPCManager.removeNPC(this);
    }

    @Override
    protected void update0() {
    }

    private void sendSpawnPackets(PlayerWrapper player) {
        if (IS_BUNGEE) {
            new SClientboundSetPlayerTeamPacket().teamKey(AdventureHelper.toLegacy(this.tabListName)).mode(SClientboundSetPlayerTeamPacket.Mode.REMOVE).displayName(this.tabListName).collisionRule(this.collisionRule).tagVisibility(SClientboundSetPlayerTeamPacket.TagVisibility.NEVER).teamColor(NamedTextColor.BLACK).teamPrefix(Component.empty()).teamSuffix(Component.empty()).friendlyFire(false).seeInvisible(true).entities(Collections.singletonList(AdventureHelper.toLegacy(this.tabListName))).sendPacket(player);
        }
        new SClientboundSetPlayerTeamPacket().teamKey(AdventureHelper.toLegacy(this.tabListName)).mode(SClientboundSetPlayerTeamPacket.Mode.CREATE).displayName(IS_BUNGEE ? Component.empty() : this.tabListName).collisionRule(this.collisionRule).tagVisibility(SClientboundSetPlayerTeamPacket.TagVisibility.NEVER).teamColor(NamedTextColor.BLACK).teamPrefix(Component.empty()).teamSuffix(Component.empty()).friendlyFire(false).seeInvisible(true).entities(Collections.singletonList(AdventureHelper.toLegacy(this.tabListName))).sendPacket(player);
        new SClientboundPlayerInfoPacket().action(SClientboundPlayerInfoPacket.Action.ADD_PLAYER).data(this.getNPCInfoData()).sendPacket(player);
        new SClientboundAddPlayerPacket().entityId(this.entityId).uuid(this.uuid()).location(this.location()).metadata(this.metadata).sendPacket(player);
        Tasker.build(() -> new SClientboundPlayerInfoPacket().action(SClientboundPlayerInfoPacket.Action.REMOVE_PLAYER).data(this.getNPCInfoData()).sendPacket(player)).delay(6L, TaskerTime.SECONDS).start();
        new SClientboundMoveEntityPacket.Rot().entityId(this.entityId()).yaw((byte)(this.location().getYaw() * 256.0f / 360.0f)).pitch((byte)(this.location().getPitch() * 256.0f / 360.0f)).onGround(true).sendPacket(player);
        new SClientboundRotateHeadPacket().entityId(this.entityId()).headYaw(this.location().getYaw()).sendPacket(player);
    }

    private SClientboundRemoveEntitiesPacket getFullDestroyPacket() {
        return new SClientboundRemoveEntitiesPacket().entityIds(new int[]{this.entityId()});
    }

    private List<SClientboundPlayerInfoPacket.PlayerInfoData> getNPCInfoData() {
        return Collections.singletonList(new SClientboundPlayerInfoPacket.PlayerInfoData(this.uuid(), AdventureHelper.toLegacy(this.tabListName), 1, GAME_MODE, this.tabListName, List.copyOf(this.properties)));
    }

    @Override
    public int entityId() {
        return this.entityId;
    }

    @Override
    public Hologram hologram() {
        return this.hologram;
    }

    @Override
    public Component tabListName() {
        return this.tabListName;
    }

    @Override
    public NPCSkin skin() {
        return this.skin;
    }

    @Override
    public boolean lookAtPlayer() {
        return this.lookAtPlayer;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    @Override
    public SClientboundSetPlayerTeamPacket.CollisionRule collisionRule() {
        return this.collisionRule;
    }

    public NPCImpl tabListName(Component tabListName) {
        this.tabListName = tabListName;
        return this;
    }

    @Override
    public NPCImpl lookAtPlayer(boolean lookAtPlayer) {
        this.lookAtPlayer = lookAtPlayer;
        return this;
    }

    @Override
    public NPCImpl collisionRule(SClientboundSetPlayerTeamPacket.CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
        return this;
    }
}

