/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.npc.skin;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.gson.GsonConfigurationLoader;
import io.github.pronze.lib.configurate.objectmapping.ConfigSerializable;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

@ConfigSerializable
public class NPCSkin {
    private static final Map<String, NPCSkin> PLAYER_NAME_SKIN_CACHE = new ConcurrentHashMap<String, NPCSkin>();
    private static final Map<UUID, NPCSkin> PLAYER_UUID_SKIN_CACHE = new ConcurrentHashMap<UUID, NPCSkin>();
    private String value;
    private String signature;

    public static CompletableFuture<@Nullable NPCSkin> retrieveSkin(String playerName) {
        return NPCSkin.retrieveSkin(playerName, false);
    }

    public static CompletableFuture<@Nullable NPCSkin> retrieveSkin(String playerName, boolean force) {
        try {
            return NPCSkin.retrieveSkin(UUID.fromString(playerName.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")), force);
        }
        catch (Throwable ignored) {
            if (PLAYER_NAME_SKIN_CACHE.containsKey(playerName) && !force) {
                return CompletableFuture.completedFuture(PLAYER_NAME_SKIN_CACHE.get(playerName));
            }
            return CompletableFuture.supplyAsync(() -> {
                try {
                    BasicConfigurationNode node = (BasicConfigurationNode)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().url(new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName))).build().load();
                    String userUUID = ((BasicConfigurationNode)node.node(new Object[]{"id"})).getString("");
                    NPCSkin skin = NPCSkin.retrieveSkin(UUID.fromString(userUUID.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")), force).get();
                    if (skin != null) {
                        PLAYER_NAME_SKIN_CACHE.put(playerName, skin);
                    }
                    return skin;
                }
                catch (Throwable throwable) {
                    return null;
                }
            });
        }
    }

    public static CompletableFuture<@Nullable NPCSkin> retrieveSkin(UUID uuid) {
        return NPCSkin.retrieveSkin(uuid, false);
    }

    public static CompletableFuture<@Nullable NPCSkin> retrieveSkin(UUID uuid, boolean force) {
        if (PLAYER_UUID_SKIN_CACHE.containsKey(uuid) && !force) {
            return CompletableFuture.completedFuture(PLAYER_UUID_SKIN_CACHE.get(uuid));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                BasicConfigurationNode node2 = (BasicConfigurationNode)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().url(new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString() + "?unsigned=false"))).build().load();
                BasicConfigurationNode skinNode = ((BasicConfigurationNode)node2.node(new Object[]{"properties"})).childrenList().stream().filter(property -> "textures".equalsIgnoreCase(((BasicConfigurationNode)property.node(new Object[]{"name"})).getString(""))).findFirst().orElseThrow();
                NPCSkin skin = new NPCSkin(((BasicConfigurationNode)skinNode.node(new Object[]{"value"})).getString(), ((BasicConfigurationNode)skinNode.node(new Object[]{"signature"})).getString());
                PLAYER_UUID_SKIN_CACHE.put(uuid, skin);
                return skin;
            }
            catch (Throwable throwable) {
                return null;
            }
        });
    }

    public NPCSkin(String value, String signature) {
        this.value = value;
        this.signature = signature;
    }

    public NPCSkin() {
    }

    public String getValue() {
        return this.value;
    }

    public String getSignature() {
        return this.signature;
    }
}

