/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.MetadataItem;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.netty.buffer.ByteBuf;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class PacketWriter
extends OutputStream {
    public static int MAX_STRING_LENGTH = Short.MAX_VALUE;
    private final ByteBuf buffer;
    private final List<AbstractPacket> appendedPackets = new ArrayList<AbstractPacket>();

    public static int getVarIntSize(int value) {
        for (int j = 1; j < 5; ++j) {
            if ((value & -1 << j * 7) != 0) continue;
            return j;
        }
        return 5;
    }

    public static long getVarLongSize(long value) {
        for (int j = 1; j < 10; ++j) {
            if ((value & -1L << j * 7) != 0L) continue;
            return j;
        }
        return 10L;
    }

    public void writeComponent(Component component) {
        this.writeSizedString(GsonComponentSerializer.gson().serializeOr(component, "{\"text\":\"\"}"));
    }

    public void writeBoolean(boolean b) {
        this.buffer.writeBoolean(b);
    }

    public void writeByte(byte b) {
        this.buffer.writeByte((int)b);
    }

    public void writeChar(char c) {
        this.buffer.writeChar((int)c);
    }

    public void writeShort(int s) {
        this.buffer.writeShort(s);
    }

    public void writeInt(int i) {
        this.buffer.writeInt(i);
    }

    public void writeLong(long l) {
        this.buffer.writeLong(l);
    }

    public void writeFloat(float f) {
        this.buffer.writeFloat(f);
    }

    public void writeDouble(double d) {
        this.buffer.writeDouble(d);
    }

    public void writeVarInt(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.buffer.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.buffer.writeShort(w);
        } else {
            this.writeVarIntFull(value);
        }
    }

    public void writeVarIntFull(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.buffer.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.buffer.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            this.buffer.writeMedium(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            this.buffer.writeInt(w);
            this.buffer.writeByte(value >>> 28);
        }
    }

    public void writeVarLong(long value) {
        do {
            byte temp = (byte)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                temp = (byte)(temp | 0x80);
            }
            this.writeByte(temp);
        } while (value != 0L);
    }

    public void writeSizedString(String string) {
        this.writeSizedString(string, MAX_STRING_LENGTH);
    }

    public void writeSizedString(String string, int maxLength) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > maxLength) {
            throw new UnsupportedOperationException("String too big! (is " + bytes.length + " bytes encoded, should be less than: " + maxLength + ")");
        }
        this.writeVarInt(bytes.length);
        this.buffer.writeBytes(bytes);
    }

    public void writeNullTerminatedString(String s) {
        this.buffer.writeCharSequence((CharSequence)(s + "\u0000"), StandardCharsets.UTF_8);
    }

    public void writeVarIntArray(int[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (int element : array) {
            this.writeVarInt(element);
        }
    }

    public void writeLongArray(long[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (long element : array) {
            this.writeLong(element);
        }
    }

    public void writeBytes(byte[] bytes) {
        this.buffer.writeBytes(bytes);
    }

    public void writeStringCollection(Collection<String> collection) {
        if (collection == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(collection.size());
        for (String element : collection) {
            this.writeSizedString(element);
        }
    }

    public void writeStringArray(String[] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (String element : array) {
            this.writeSizedString(element);
        }
    }

    public void writeUuid(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public void writeBlockPosition(LocationHolder location) {
        this.writeBlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public void writeByteOffset(Vector3Df main, Vector3Df location) {
        this.writeByte((byte)(location.getX() - main.getX()));
        this.writeByte((byte)(location.getY() - main.getY()));
        this.writeByte((byte)(location.getZ() - main.getZ()));
    }

    public void writeBlockPosition(int x, int y, int z) {
        this.writeLong(((long)x & 0x3FFFFFFL) << 38 | ((long)z & 0x3FFFFFFL) << 12 | (long)y & 0xFFFL);
    }

    public void writeVector(Vector3D vector3D) {
        this.writeDouble(vector3D.getX());
        this.writeDouble(vector3D.getY());
        this.writeDouble(vector3D.getZ());
    }

    public void writeVector(LocationHolder locationHolder) {
        this.writeVector(locationHolder.asVector());
    }

    public void writeFixedPointVector(LocationHolder locationHolder) {
        this.writeFixedPointVector(locationHolder.asVector());
    }

    public void writeFixedPointVector(Vector3D vector3D) {
        this.writeInt((int)(vector3D.getX() * 32.0));
        this.writeInt((int)(vector3D.getY() * 32.0));
        this.writeInt((int)(vector3D.getZ() * 32.0));
    }

    public void writeByteRotation(LocationHolder locationHolder) {
        this.writeByteRotation(locationHolder.getYaw(), locationHolder.getPitch());
    }

    public void writeByteRotation(float yaw, float pitch) {
        this.writeByte((byte)(yaw * 256.0f / 360.0f));
        this.writeByte((byte)(pitch * 256.0f / 360.0f));
    }

    public void writeVector(Vector3Df vector3Df) {
        this.writeFloat(vector3Df.getX());
        this.writeFloat(vector3Df.getY());
        this.writeFloat(vector3Df.getZ());
    }

    public void writeMotion(Vector3D vector3D) {
        this.writeShort((int)(vector3D.getX() * 8000.0));
        this.writeShort((int)(vector3D.getY() * 8000.0));
        this.writeShort((int)(vector3D.getZ() * 8000.0));
    }

    public void writeMove(Vector3D vector3D) {
        this.writeShort((int)(vector3D.getX() * 4096.0));
        this.writeShort((int)(vector3D.getY() * 4096.0));
        this.writeShort((int)(vector3D.getZ() * 4096.0));
    }

    public void writeItem(Item item) {
        if (item.getMaterial().isAir()) {
            if (this.protocol() >= 402) {
                this.writeBoolean(false);
            } else {
                this.writeShort(-1);
            }
        } else {
            if (this.protocol() >= 402) {
                this.writeBoolean(true);
                this.writeVarInt(this.getItemId(item.getMaterial()));
            } else {
                this.writeShort(this.getItemId(item.getMaterial()));
            }
            this.write(item.getAmount());
            if (this.protocol() < 351) {
                this.writeShort(item.getMaterial().forcedDurability());
            }
            this.writeNBTFromItem(item);
        }
    }

    public <T> void writeSizedArray(T[] array, Consumer<T> consumer) {
        this.writeVarInt(array.length);
        for (T a : array) {
            consumer.accept(a);
        }
    }

    public <T> void writeSizedCollection(Collection<T> collection, Consumer<T> consumer) {
        this.writeVarInt(collection.size());
        for (T a : collection) {
            consumer.accept(a);
        }
    }

    public <K, V> void writeSizedMap(Map<K, V> map, BiConsumer<K, V> consumer) {
        this.writeVarInt(map.size());
        for (Map.Entry<K, V> a : map.entrySet()) {
            consumer.accept(a.getKey(), a.getValue());
        }
    }

    public void writeBlockData(BlockTypeHolder blockDataHolder) {
        this.writeVarInt(this.getBlockStateId(blockDataHolder));
    }

    public void writeDataWatcherCollection(Collection<MetadataItem> collection) {
        for (MetadataItem item : collection) {
            item.write(this);
        }
        this.writeByte((byte)-1);
    }

    public void writeNBTFromItem(Item item) {
        this.write(0);
    }

    public void append(AbstractPacket packet) {
        this.appendedPackets.add(packet);
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    public int protocol() {
        return Server.getProtocolVersion();
    }

    protected abstract int getItemId(ItemTypeHolder var1);

    protected abstract int getBlockStateId(BlockTypeHolder var1);

    public abstract int getEquipmentSlotId(EquipmentSlotHolder var1);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketWriter)) {
            return false;
        }
        PacketWriter other = (PacketWriter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteBuf this$buffer = this.getBuffer();
        ByteBuf other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !this$buffer.equals(other$buffer)) {
            return false;
        }
        List<AbstractPacket> this$appendedPackets = this.getAppendedPackets();
        List<AbstractPacket> other$appendedPackets = other.getAppendedPackets();
        return !(this$appendedPackets == null ? other$appendedPackets != null : !((Object)this$appendedPackets).equals(other$appendedPackets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketWriter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ByteBuf $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : $buffer.hashCode());
        List<AbstractPacket> $appendedPackets = this.getAppendedPackets();
        result = result * 59 + ($appendedPackets == null ? 43 : ((Object)$appendedPackets).hashCode());
        return result;
    }

    public PacketWriter(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public List<AbstractPacket> getAppendedPackets() {
        return this.appendedPackets;
    }

    public String toString() {
        return "PacketWriter(buffer=" + this.getBuffer() + ", appendedPackets=" + this.getAppendedPackets() + ")";
    }
}

