/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.UUID;

public class SClientboundAddEntityPacket
extends AbstractPacket {
    private int entityId;
    private UUID uuid;
    private LocationHolder location;
    private Vector3D velocity;
    private int typeId;
    private int data;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        if (writer.protocol() >= 49) {
            writer.writeUuid(this.uuid);
        }
        if (writer.protocol() >= 458) {
            writer.writeVarInt(this.typeId);
        } else {
            writer.writeByte((byte)this.typeId);
        }
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        writer.writeByteRotation(this.location);
        writer.writeInt(this.data);
        if (this.data != 0 || writer.protocol() >= 49) {
            writer.writeMotion(this.velocity);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundAddEntityPacket)) {
            return false;
        }
        SClientboundAddEntityPacket other = (SClientboundAddEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.typeId() != other.typeId()) {
            return false;
        }
        if (this.data() != other.data()) {
            return false;
        }
        UUID this$uuid = this.uuid();
        UUID other$uuid = other.uuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        LocationHolder this$location = this.location();
        LocationHolder other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Vector3D this$velocity = this.velocity();
        Vector3D other$velocity = other.velocity();
        return !(this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundAddEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.typeId();
        result = result * 59 + this.data();
        UUID $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        LocationHolder $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Vector3D $velocity = this.velocity();
        result = result * 59 + ($velocity == null ? 43 : ((Object)$velocity).hashCode());
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public LocationHolder location() {
        return this.location;
    }

    public Vector3D velocity() {
        return this.velocity;
    }

    public int typeId() {
        return this.typeId;
    }

    public int data() {
        return this.data;
    }

    public SClientboundAddEntityPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public SClientboundAddEntityPacket uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public SClientboundAddEntityPacket location(LocationHolder location) {
        this.location = location;
        return this;
    }

    public SClientboundAddEntityPacket velocity(Vector3D velocity) {
        this.velocity = velocity;
        return this;
    }

    public SClientboundAddEntityPacket typeId(int typeId) {
        this.typeId = typeId;
        return this;
    }

    public SClientboundAddEntityPacket data(int data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return "SClientboundAddEntityPacket(entityId=" + this.entityId() + ", uuid=" + this.uuid() + ", location=" + this.location() + ", velocity=" + this.velocity() + ", typeId=" + this.typeId() + ", data=" + this.data() + ")";
    }
}

