/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.MetadataItem;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetEntityDataPacket;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SClientboundAddMobPacket
extends AbstractPacket {
    private int entityId;
    private UUID uuid;
    private LocationHolder location;
    private Vector3D velocity;
    private int typeId;
    private final List<MetadataItem> metadata = new ArrayList<MetadataItem>();
    private byte headYaw;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        if (writer.protocol() >= 49) {
            writer.writeUuid(this.uuid);
        }
        if (writer.protocol() >= 301) {
            writer.writeVarInt(this.typeId);
        } else {
            writer.writeByte((byte)this.typeId);
        }
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        writer.writeByteRotation(this.location);
        writer.writeByte(this.headYaw);
        writer.writeMotion(this.velocity);
        if (writer.protocol() >= 550) {
            if (!this.metadata.isEmpty()) {
                SClientboundSetEntityDataPacket packet = new SClientboundSetEntityDataPacket();
                packet.entityId(this.entityId);
                packet.metadata().addAll(this.metadata);
                writer.append(packet);
            }
        } else {
            writer.writeDataWatcherCollection(this.metadata);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundAddMobPacket)) {
            return false;
        }
        SClientboundAddMobPacket other = (SClientboundAddMobPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.typeId() != other.typeId()) {
            return false;
        }
        if (this.headYaw() != other.headYaw()) {
            return false;
        }
        UUID this$uuid = this.uuid();
        UUID other$uuid = other.uuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        LocationHolder this$location = this.location();
        LocationHolder other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Vector3D this$velocity = this.velocity();
        Vector3D other$velocity = other.velocity();
        if (this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity)) {
            return false;
        }
        List<MetadataItem> this$metadata = this.metadata();
        List<MetadataItem> other$metadata = other.metadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundAddMobPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.typeId();
        result = result * 59 + this.headYaw();
        UUID $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        LocationHolder $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Vector3D $velocity = this.velocity();
        result = result * 59 + ($velocity == null ? 43 : ((Object)$velocity).hashCode());
        List<MetadataItem> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public LocationHolder location() {
        return this.location;
    }

    public Vector3D velocity() {
        return this.velocity;
    }

    public int typeId() {
        return this.typeId;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    public byte headYaw() {
        return this.headYaw;
    }

    public SClientboundAddMobPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public SClientboundAddMobPacket uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public SClientboundAddMobPacket location(LocationHolder location) {
        this.location = location;
        return this;
    }

    public SClientboundAddMobPacket velocity(Vector3D velocity) {
        this.velocity = velocity;
        return this;
    }

    public SClientboundAddMobPacket typeId(int typeId) {
        this.typeId = typeId;
        return this;
    }

    public SClientboundAddMobPacket headYaw(byte headYaw) {
        this.headYaw = headYaw;
        return this;
    }

    public String toString() {
        return "SClientboundAddMobPacket(entityId=" + this.entityId() + ", uuid=" + this.uuid() + ", location=" + this.location() + ", velocity=" + this.velocity() + ", typeId=" + this.typeId() + ", metadata=" + this.metadata() + ", headYaw=" + this.headYaw() + ")";
    }
}

