/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.MetadataItem;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetEntityDataPacket;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.List;
import java.util.UUID;

public class SClientboundAddPlayerPacket
extends AbstractPacket {
    private int entityId;
    private UUID uuid;
    private LocationHolder location;
    private List<MetadataItem> metadata;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        writer.writeUuid(this.uuid);
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        writer.writeByteRotation(this.location);
        if (writer.protocol() < 49) {
            writer.writeShort(0);
        }
        if (writer.protocol() >= 550) {
            if (!this.metadata.isEmpty()) {
                SClientboundSetEntityDataPacket packet = new SClientboundSetEntityDataPacket();
                packet.entityId(this.entityId);
                packet.metadata().addAll(this.metadata);
                writer.append(packet);
            }
        } else {
            writer.writeDataWatcherCollection(this.metadata);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundAddPlayerPacket)) {
            return false;
        }
        SClientboundAddPlayerPacket other = (SClientboundAddPlayerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        UUID this$uuid = this.uuid();
        UUID other$uuid = other.uuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        LocationHolder this$location = this.location();
        LocationHolder other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<MetadataItem> this$metadata = this.metadata();
        List<MetadataItem> other$metadata = other.metadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundAddPlayerPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        UUID $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        LocationHolder $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<MetadataItem> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public LocationHolder location() {
        return this.location;
    }

    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    public SClientboundAddPlayerPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public SClientboundAddPlayerPacket uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public SClientboundAddPlayerPacket location(LocationHolder location) {
        this.location = location;
        return this;
    }

    public SClientboundAddPlayerPacket metadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String toString() {
        return "SClientboundAddPlayerPacket(entityId=" + this.entityId() + ", uuid=" + this.uuid() + ", location=" + this.location() + ", metadata=" + this.metadata() + ")";
    }
}

