/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;

public class SClientboundEntityEventPacket
extends AbstractPacket {
    private int entityId;
    private Status status;

    @Override
    public void write(PacketWriter writer) {
        writer.writeInt(this.entityId);
        if (writer.protocol() < 210 && (this.status == Status.SMOKE || this.status == Status.HURT)) {
            if (this.status == Status.SMOKE) {
                writer.writeByte((byte)7);
            } else {
                writer.writeByte((byte)6);
            }
        } else {
            writer.writeByte((byte)this.status.ordinal());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundEntityEventPacket)) {
            return false;
        }
        SClientboundEntityEventPacket other = (SClientboundEntityEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        Status this$status = this.status();
        Status other$status = other.status();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundEntityEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        Status $status = this.status();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public Status status() {
        return this.status;
    }

    public SClientboundEntityEventPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public SClientboundEntityEventPacket status(Status status) {
        this.status = status;
        return this;
    }

    public String toString() {
        return "SClientboundEntityEventPacket(entityId=" + this.entityId() + ", status=" + this.status() + ")";
    }

    public static enum Status {
        ARROW,
        RABBIT_JUMP,
        HURT,
        DEATH,
        ATTACK,
        UNUSED_1,
        SMOKE,
        HEART,
        SHAKING_WATER,
        PLAYER_FINISHED_USING,
        GRASS_EATING,
        IRON_GOLEM_FLOWER,
        VILLAGER_MATING,
        VILLAGER_ANGRY,
        VILLAGER_HAPPY,
        WITCH_MAGIC,
        ZOMBIE_CURE,
        FIREWORK_EXPLOSION,
        ANIMAL_IN_LOVE,
        SQUID_ROTATION_RESET,
        SPAWN_EXPLOSION_PARTICLE,
        GUARDIAN_SOUND,
        REDUCED_DEBUG_SCREEN,
        DISABLE_REDUCED_DEBUG_SCREEN,
        OP_0,
        OP_1,
        OP_2,
        OP_3,
        OP_4,
        SHIELD_BLOCK,
        SHIELD_BREAK,
        PULL_PLAYER,
        ARMOR_STAND_HIT,
        THORNS_HURT,
        IRON_GOLEM_UNFLOWER,
        TOTEM,
        DROWN,
        BURN,
        DOLPHIN,
        RAVARGE_STUNNED,
        NEW_OCELOT_TAMING_FAILED,
        NEW_OCELOT_TAMING_SUCCESS,
        VILLAGER_SPLASH,
        PLAYER_CLOUD,
        SWEET_BERRY_HURT,
        FOX_MOUTH,
        CHORUS_TELEPORT,
        MAIN_HAND_BREAK,
        OFF_HAND_BREAK,
        HEAD_SLOT_BREAK,
        CHEST_SLOT_BREAK,
        LEGS_SLOT_BREAK,
        FEET_SLOT_BREAK,
        HONEY_SLIDE,
        HONEY_FALL,
        HAND_SWAP;

    }
}

