/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;

public class SClientboundPlayerAbilitiesPacket
extends AbstractPacket {
    private boolean invulnerable;
    private boolean flying;
    private boolean canFly;
    private boolean canInstantlyBreak;
    private float flyingSpeed;
    private float walkingSpeed;

    @Override
    public void write(PacketWriter writer) {
        byte flags = 0;
        if (this.invulnerable) {
            flags = (byte)(flags | 1);
        }
        if (this.flying) {
            flags = (byte)(flags | 2);
        }
        if (this.canFly) {
            flags = (byte)(flags | 4);
        }
        if (this.canInstantlyBreak) {
            flags = (byte)(flags | 8);
        }
        writer.writeByte(flags);
        writer.writeFloat(this.flyingSpeed);
        writer.writeFloat(this.walkingSpeed);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundPlayerAbilitiesPacket)) {
            return false;
        }
        SClientboundPlayerAbilitiesPacket other = (SClientboundPlayerAbilitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.invulnerable() != other.invulnerable()) {
            return false;
        }
        if (this.flying() != other.flying()) {
            return false;
        }
        if (this.canFly() != other.canFly()) {
            return false;
        }
        if (this.canInstantlyBreak() != other.canInstantlyBreak()) {
            return false;
        }
        if (Float.compare(this.flyingSpeed(), other.flyingSpeed()) != 0) {
            return false;
        }
        return Float.compare(this.walkingSpeed(), other.walkingSpeed()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundPlayerAbilitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.invulnerable() ? 79 : 97);
        result = result * 59 + (this.flying() ? 79 : 97);
        result = result * 59 + (this.canFly() ? 79 : 97);
        result = result * 59 + (this.canInstantlyBreak() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.flyingSpeed());
        result = result * 59 + Float.floatToIntBits(this.walkingSpeed());
        return result;
    }

    public boolean invulnerable() {
        return this.invulnerable;
    }

    public boolean flying() {
        return this.flying;
    }

    public boolean canFly() {
        return this.canFly;
    }

    public boolean canInstantlyBreak() {
        return this.canInstantlyBreak;
    }

    public float flyingSpeed() {
        return this.flyingSpeed;
    }

    public float walkingSpeed() {
        return this.walkingSpeed;
    }

    public SClientboundPlayerAbilitiesPacket invulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
        return this;
    }

    public SClientboundPlayerAbilitiesPacket flying(boolean flying) {
        this.flying = flying;
        return this;
    }

    public SClientboundPlayerAbilitiesPacket canFly(boolean canFly) {
        this.canFly = canFly;
        return this;
    }

    public SClientboundPlayerAbilitiesPacket canInstantlyBreak(boolean canInstantlyBreak) {
        this.canInstantlyBreak = canInstantlyBreak;
        return this;
    }

    public SClientboundPlayerAbilitiesPacket flyingSpeed(float flyingSpeed) {
        this.flyingSpeed = flyingSpeed;
        return this;
    }

    public SClientboundPlayerAbilitiesPacket walkingSpeed(float walkingSpeed) {
        this.walkingSpeed = walkingSpeed;
        return this;
    }

    public String toString() {
        return "SClientboundPlayerAbilitiesPacket(invulnerable=" + this.invulnerable() + ", flying=" + this.flying() + ", canFly=" + this.canFly() + ", canInstantlyBreak=" + this.canInstantlyBreak() + ", flyingSpeed=" + this.flyingSpeed() + ", walkingSpeed=" + this.walkingSpeed() + ")";
    }
}

