/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.player.gamemode.GameModeHolder;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class SClientboundPlayerInfoPacket
extends AbstractPacket {
    private Action action;
    private List<PlayerInfoData> data;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.action.ordinal());
        writer.writeSizedCollection(this.data, playerInfoData -> {
            writer.writeUuid(playerInfoData.uuid());
            switch (this.action) {
                case ADD_PLAYER: {
                    writer.writeSizedString(playerInfoData.realName());
                    writer.writeSizedCollection(playerInfoData.properties(), property -> {
                        writer.writeSizedString(property.name());
                        writer.writeSizedString(property.value());
                        boolean hasSignature = property.hasSignature();
                        writer.writeBoolean(hasSignature);
                        if (hasSignature) {
                            writer.writeSizedString(property.signature());
                        }
                    });
                    writer.writeVarInt(playerInfoData.gameMode().id());
                    writer.writeVarInt(playerInfoData.latency());
                    writer.writeBoolean(playerInfoData.displayName() != null);
                    if (playerInfoData.displayName() == null) break;
                    writer.writeComponent(playerInfoData.displayName());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    writer.writeVarInt(playerInfoData.gameMode().id());
                    break;
                }
                case UPDATE_LATENCY: {
                    writer.writeVarInt(playerInfoData.latency());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    writer.writeBoolean(playerInfoData.displayName() != null);
                    if (playerInfoData.displayName() == null) break;
                    writer.writeComponent(playerInfoData.displayName());
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundPlayerInfoPacket)) {
            return false;
        }
        SClientboundPlayerInfoPacket other = (SClientboundPlayerInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Action this$action = this.action();
        Action other$action = other.action();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        List<PlayerInfoData> this$data = this.data();
        List<PlayerInfoData> other$data = other.data();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundPlayerInfoPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Action $action = this.action();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        List<PlayerInfoData> $data = this.data();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public Action action() {
        return this.action;
    }

    public List<PlayerInfoData> data() {
        return this.data;
    }

    public SClientboundPlayerInfoPacket action(Action action) {
        this.action = action;
        return this;
    }

    public SClientboundPlayerInfoPacket data(List<PlayerInfoData> data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return "SClientboundPlayerInfoPacket(action=" + this.action() + ", data=" + this.data() + ")";
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    public static class PlayerInfoData {
        private final UUID uuid;
        private final String realName;
        private final int latency;
        private final GameModeHolder gameMode;
        private final Component displayName;
        private final List<Property> properties;

        public PlayerInfoData(UUID uuid, String realName, int latency, GameModeHolder gameMode, Component displayName, List<Property> properties) {
            this.uuid = uuid;
            this.realName = realName;
            this.latency = latency;
            this.gameMode = gameMode;
            this.displayName = displayName;
            this.properties = properties;
        }

        public UUID uuid() {
            return this.uuid;
        }

        public String realName() {
            return this.realName;
        }

        public int latency() {
            return this.latency;
        }

        public GameModeHolder gameMode() {
            return this.gameMode;
        }

        public Component displayName() {
            return this.displayName;
        }

        public List<Property> properties() {
            return this.properties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerInfoData)) {
                return false;
            }
            PlayerInfoData other = (PlayerInfoData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.latency() != other.latency()) {
                return false;
            }
            UUID this$uuid = this.uuid();
            UUID other$uuid = other.uuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$realName = this.realName();
            String other$realName = other.realName();
            if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
                return false;
            }
            GameModeHolder this$gameMode = this.gameMode();
            GameModeHolder other$gameMode = other.gameMode();
            if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
                return false;
            }
            Component this$displayName = this.displayName();
            Component other$displayName = other.displayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            List<Property> this$properties = this.properties();
            List<Property> other$properties = other.properties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlayerInfoData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.latency();
            UUID $uuid = this.uuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $realName = this.realName();
            result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
            GameModeHolder $gameMode = this.gameMode();
            result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
            Component $displayName = this.displayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            List<Property> $properties = this.properties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "SClientboundPlayerInfoPacket.PlayerInfoData(uuid=" + this.uuid() + ", realName=" + this.realName() + ", latency=" + this.latency() + ", gameMode=" + this.gameMode() + ", displayName=" + this.displayName() + ", properties=" + this.properties() + ")";
        }
    }

    public static class Property {
        private final String name;
        private final String value;
        @Nullable
        private final String signature;

        public Property(String name, String value) {
            this(name, value, null);
        }

        public boolean hasSignature() {
            return this.signature != null;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        @Nullable
        public String signature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.value();
            String other$value = other.value();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        public String toString() {
            return "SClientboundPlayerInfoPacket.Property(name=" + this.name() + ", value=" + this.value() + ", signature=" + this.signature() + ")";
        }

        public Property(String name, String value, @Nullable String signature) {
            this.name = name;
            this.value = value;
            this.signature = signature;
        }
    }
}

