/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;

public class SClientboundUpdateMobEffectPacket
extends AbstractPacket {
    private int entityId;
    private byte effect;
    private byte amplifier;
    private int duration;
    private boolean ambient;
    private boolean showParticles;
    private boolean showIcons;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        writer.writeByte(this.effect);
        writer.writeByte(this.amplifier);
        writer.writeVarInt(this.duration);
        if (writer.protocol() >= 210) {
            byte flags = 0;
            if (this.ambient) {
                flags = (byte)(flags | 1);
            }
            if (this.showParticles) {
                flags = (byte)(flags | 2);
            }
            if (this.showIcons) {
                flags = (byte)(flags | 4);
            }
            writer.writeByte(flags);
        } else {
            writer.writeBoolean(!this.showParticles);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundUpdateMobEffectPacket)) {
            return false;
        }
        SClientboundUpdateMobEffectPacket other = (SClientboundUpdateMobEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.effect() != other.effect()) {
            return false;
        }
        if (this.amplifier() != other.amplifier()) {
            return false;
        }
        if (this.duration() != other.duration()) {
            return false;
        }
        if (this.ambient() != other.ambient()) {
            return false;
        }
        if (this.showParticles() != other.showParticles()) {
            return false;
        }
        return this.showIcons() == other.showIcons();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundUpdateMobEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.effect();
        result = result * 59 + this.amplifier();
        result = result * 59 + this.duration();
        result = result * 59 + (this.ambient() ? 79 : 97);
        result = result * 59 + (this.showParticles() ? 79 : 97);
        result = result * 59 + (this.showIcons() ? 79 : 97);
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public byte effect() {
        return this.effect;
    }

    public byte amplifier() {
        return this.amplifier;
    }

    public int duration() {
        return this.duration;
    }

    public boolean ambient() {
        return this.ambient;
    }

    public boolean showParticles() {
        return this.showParticles;
    }

    public boolean showIcons() {
        return this.showIcons;
    }

    public SClientboundUpdateMobEffectPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public SClientboundUpdateMobEffectPacket effect(byte effect) {
        this.effect = effect;
        return this;
    }

    public SClientboundUpdateMobEffectPacket amplifier(byte amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public SClientboundUpdateMobEffectPacket duration(int duration) {
        this.duration = duration;
        return this;
    }

    public SClientboundUpdateMobEffectPacket ambient(boolean ambient) {
        this.ambient = ambient;
        return this;
    }

    public SClientboundUpdateMobEffectPacket showParticles(boolean showParticles) {
        this.showParticles = showParticles;
        return this;
    }

    public SClientboundUpdateMobEffectPacket showIcons(boolean showIcons) {
        this.showIcons = showIcons;
        return this;
    }

    public String toString() {
        return "SClientboundUpdateMobEffectPacket(entityId=" + this.entityId() + ", effect=" + this.effect() + ", amplifier=" + this.amplifier() + ", duration=" + this.duration() + ", ambient=" + this.ambient() + ", showParticles=" + this.showParticles() + ", showIcons=" + this.showIcons() + ")";
    }
}

