/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet.entity;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.MetadataItem;
import io.github.pronze.lib.screaminglib.packet.SClientboundAddMobPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetEntityDataPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundTeleportEntityPacket;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.SenderMessage;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;

public class FakeEntity {
    private final int id;
    private LocationHolder location;
    private final int typeId;
    private final UUID uuid;
    private final List<MetadataItem> metadataItems;
    private byte entityFlags;
    private Component customName;
    @Nullable
    private SenderMessage customNameSenderMessage;
    private boolean isOnGround;

    public FakeEntity(LocationHolder location, int typeId) {
        if (!Server.isServerThread()) {
            try {
                this.id = EntityMapper.getNewEntityIdSynchronously().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.id = EntityMapper.getNewEntityId();
        }
        this.typeId = typeId;
        this.location = location;
        this.uuid = UUID.randomUUID();
        this.metadataItems = Collections.synchronizedList(new ArrayList());
        this.entityFlags = 0;
        this.customName = Component.empty();
        this.isOnGround = true;
        this.setEntityFlags();
    }

    public void setCustomName(Component name) {
        if (Server.isVersion(1, 13)) {
            this.put(MetadataItem.ofOpt(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), name));
        } else {
            String str = AdventureHelper.toLegacy(name);
            if (str.length() > 256) {
                str = str.substring(0, 256);
            }
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), str));
        }
        this.customName = name;
    }

    public void put(MetadataItem metadataItem) {
        this.metadataItems.removeIf(metadataItem1 -> metadataItem1.getIndex() == metadataItem.getIndex());
        this.metadataItems.add(metadataItem);
    }

    public void setEntityFlags() {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.ENTITY_FLAGS), this.entityFlags));
    }

    public void setAirTicks(int airTicks) {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.AIR_TICKS), airTicks));
    }

    public void setCustomNameVisible(boolean customNameVisible) {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME_VISIBLE), customNameVisible));
    }

    public void setSilent(boolean silent) {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.IS_SILENT), silent));
    }

    public void setGravity(boolean gravity) {
        if (Server.isVersion(1, 10)) {
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.HAS_NO_GRAVITY), !gravity));
        }
    }

    public void setPose(int poseOrdinal) {
        if (Server.isVersion(1, 14)) {
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.POSE), poseOrdinal));
        }
    }

    public void setTicksFrozen(int ticksFrozen) {
        if (Server.isVersion(1, 17)) {
            MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.TICKS_FROZEN), ticksFrozen);
        }
    }

    public void setInvisible(boolean invisible) {
        this.setEntityFlagsFromValue(5, invisible);
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.ENTITY_FLAGS), this.entityFlags));
    }

    public void setEntityFlagsFromValue(int index, boolean value) {
        this.entityFlags = value ? (byte)(this.entityFlags | 1 << index) : (byte)(this.entityFlags & ~(1 << index));
    }

    public void spawn(PlayerWrapper player) {
        this.getSpawnPackets().forEach(packet -> packet.sendPacket(player));
    }

    public void teleport(PlayerWrapper player) {
        this.getTeleportPacket().sendPacket(player);
    }

    public List<AbstractPacket> getSpawnPackets() {
        return this.getSpawnPackets(List.of());
    }

    public List<AbstractPacket> getSpawnPackets(PlayerWrapper viewer) {
        if (this.customNameSenderMessage != null) {
            if (Server.isVersion(1, 13)) {
                return this.getSpawnPackets(List.of(MetadataItem.ofOpt(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), this.customNameSenderMessage.asComponent(viewer))));
            }
            String str = AdventureHelper.toLegacy(this.customNameSenderMessage.asComponent(viewer));
            if (str.length() > 256) {
                str = str.substring(0, 256);
            }
            return this.getSpawnPackets(List.of(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), str)));
        }
        return this.getSpawnPackets(List.of());
    }

    public List<AbstractPacket> getSpawnPackets(List<MetadataItem> additionalMetadata) {
        LinkedList<AbstractPacket> toReturn = new LinkedList<AbstractPacket>();
        SClientboundAddMobPacket spawnPacket = new SClientboundAddMobPacket().entityId(this.id).uuid(this.uuid).typeId(this.typeId).velocity(new Vector3D(0.0, 0.0, 0.0)).headYaw((byte)3).location(this.location);
        spawnPacket.metadata().addAll(this.metadataItems);
        additionalMetadata.forEach(metadataItem -> {
            spawnPacket.metadata().removeIf(metadataItem1 -> metadataItem1.getIndex() == metadataItem.getIndex());
            spawnPacket.metadata().add((MetadataItem)metadataItem);
        });
        toReturn.add(spawnPacket);
        return toReturn;
    }

    public SClientboundTeleportEntityPacket getTeleportPacket() {
        return new SClientboundTeleportEntityPacket().entityId(this.id).location(this.location).onGround(this.isOnGround);
    }

    public SClientboundSetEntityDataPacket getMetadataPacket() {
        return this.getMetadataPacket(List.of());
    }

    public SClientboundSetEntityDataPacket getMetadataPacket(PlayerWrapper viewer) {
        if (this.customNameSenderMessage != null) {
            if (Server.isVersion(1, 13)) {
                return this.getMetadataPacket(List.of(MetadataItem.ofOpt(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), this.customNameSenderMessage.asComponent(viewer))));
            }
            String str = AdventureHelper.toLegacy(this.customNameSenderMessage.asComponent(viewer));
            if (str.length() > 256) {
                str = str.substring(0, 256);
            }
            return this.getMetadataPacket(List.of(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), str)));
        }
        return this.getMetadataPacket(List.of());
    }

    public SClientboundSetEntityDataPacket getMetadataPacket(List<MetadataItem> additionalMetadata) {
        SClientboundSetEntityDataPacket metadataPacket = new SClientboundSetEntityDataPacket().entityId(this.id);
        metadataPacket.metadata().addAll(this.metadataItems);
        additionalMetadata.forEach(metadataItem -> {
            metadataPacket.metadata().removeIf(metadataItem1 -> metadataItem1.getIndex() == metadataItem.getIndex());
            metadataPacket.metadata().add((MetadataItem)metadataItem);
        });
        return metadataPacket;
    }

    public int getId() {
        return this.id;
    }

    public LocationHolder getLocation() {
        return this.location;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<MetadataItem> getMetadataItems() {
        return this.metadataItems;
    }

    public byte getEntityFlags() {
        return this.entityFlags;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean isOnGround() {
        return this.isOnGround;
    }

    public void setLocation(LocationHolder location) {
        this.location = location;
    }

    @Nullable
    public SenderMessage getCustomNameSenderMessage() {
        return this.customNameSenderMessage;
    }

    public void setCustomNameSenderMessage(@Nullable SenderMessage customNameSenderMessage) {
        this.customNameSenderMessage = customNameSenderMessage;
    }

    public void setOnGround(boolean isOnGround) {
        this.isOnGround = isOnGround;
    }

    protected static enum EntityMetadata {
        ENTITY_FLAGS,
        AIR_TICKS,
        CUSTOM_NAME,
        CUSTOM_NAME_VISIBLE,
        IS_SILENT,
        HAS_NO_GRAVITY,
        POSE,
        TICKS_FROZEN,
        HAND_STATES,
        HEALTH,
        POTION_EFFECT_COLOR,
        POTION_AMBIENCY,
        BODY_ARROW_COUNT,
        BEE_STINGER_COUNT,
        BED_BLOCK_POSITION,
        ARMOR_STAND_FLAGS,
        HEAD_ROTATION,
        BODY_ROTATION,
        LEFT_ARM_ROTATION,
        RIGHT_ARM_ROTATION,
        LEFT_LEG_ROTATION,
        RIGHT_LEG_ROTATION;


        public static class Registry {
            private static final Map<EntityMetadata, Byte> idMap = new HashMap<EntityMetadata, Byte>();
            private static byte SEQUENTIAL_INDEXING = (byte)-1;

            public static Optional<EntityMetadata> fromId(byte id) {
                for (Map.Entry<EntityMetadata, Byte> entry : idMap.entrySet()) {
                    EntityMetadata entryKey = entry.getKey();
                    Byte entryId = entry.getValue();
                    if (entryId != id) continue;
                    return Optional.of(entryKey);
                }
                return Optional.empty();
            }

            public static byte getId(EntityMetadata metadata) {
                return Objects.requireNonNull(idMap.get((Object)metadata), "Has: " + metadata.name() + " not been registered into registry?");
            }

            public static void register(EntityMetadata indices) {
                if (idMap.containsKey((Object)indices)) {
                    return;
                }
                SEQUENTIAL_INDEXING = (byte)(SEQUENTIAL_INDEXING + 1);
                idMap.put(indices, SEQUENTIAL_INDEXING);
            }

            static {
                Registry.register(ENTITY_FLAGS);
                Registry.register(AIR_TICKS);
                Registry.register(CUSTOM_NAME);
                Registry.register(CUSTOM_NAME_VISIBLE);
                Registry.register(IS_SILENT);
                if (Server.isVersion(1, 10)) {
                    Registry.register(HAS_NO_GRAVITY);
                }
                if (Server.isVersion(1, 14)) {
                    Registry.register(POSE);
                }
                if (Server.isVersion(1, 17)) {
                    Registry.register(TICKS_FROZEN);
                }
                Registry.register(HAND_STATES);
                Registry.register(HEALTH);
                Registry.register(POTION_EFFECT_COLOR);
                Registry.register(POTION_AMBIENCY);
                Registry.register(BODY_ARROW_COUNT);
                if (Server.isVersion(1, 15)) {
                    Registry.register(BEE_STINGER_COUNT);
                }
                if (Server.isVersion(1, 14)) {
                    Registry.register(BED_BLOCK_POSITION);
                }
                Registry.register(ARMOR_STAND_FLAGS);
                Registry.register(HEAD_ROTATION);
                Registry.register(BODY_ROTATION);
                Registry.register(LEFT_ARM_ROTATION);
                Registry.register(RIGHT_ARM_ROTATION);
                Registry.register(LEFT_LEG_ROTATION);
                Registry.register(RIGHT_LEG_ROTATION);
            }
        }
    }
}

