/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.particle;

import io.github.pronze.lib.screaminglib.particle.ParticleData;
import io.github.pronze.lib.screaminglib.particle.ParticleTypeMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface ParticleTypeHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    @Nullable
    public Class<? extends ParticleData> expectedDataClass();

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.PARTICLE_TYPE)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.PARTICLE_TYPE)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.PARTICLE_TYPE)
    public static ParticleTypeHolder of(Object particle) {
        return ParticleTypeHolder.ofOptional(particle).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.PARTICLE_TYPE)
    public static Optional<ParticleTypeHolder> ofOptional(Object particle) {
        if (particle instanceof ParticleTypeHolder) {
            return Optional.of((ParticleTypeHolder)particle);
        }
        return ParticleTypeMapping.resolve(particle);
    }

    public static List<ParticleTypeHolder> all() {
        return ParticleTypeMapping.getValues();
    }
}

