/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.placeholders.hooks;

import io.github.pronze.lib.screaminglib.placeholders.PlaceholderExpansion;
import io.github.pronze.lib.screaminglib.placeholders.hooks.Hook;
import io.github.pronze.lib.screaminglib.sender.MultiPlatformOfflinePlayer;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DummyHook
implements Hook {
    private static final Pattern pattern = Pattern.compile("%((?<identifier>[a-zA-Z0-9]+)_)(?<parameters>[^%]+)%");
    private final List<PlaceholderExpansion> expansions = new ArrayList<PlaceholderExpansion>();

    @Override
    public void register(PlaceholderExpansion expansion) {
        if (!this.expansions.contains(expansion)) {
            this.expansions.add(expansion);
        }
    }

    @Override
    public String resolveString(MultiPlatformOfflinePlayer player, String message) {
        Matcher matcher = pattern.matcher(message);
        if (!matcher.find()) {
            return message;
        }
        StringBuffer builder = new StringBuffer();
        do {
            String identifier = matcher.group("identifier");
            String parameters = matcher.group("parameters");
            Optional<PlaceholderExpansion> expansion = this.expansions.stream().filter(placeholderExpansion -> placeholderExpansion.getIdentifier().equals(identifier)).findFirst();
            if (expansion.isEmpty()) continue;
            String requested = AdventureHelper.toLegacyNullableResult(expansion.get().onRequest(player, parameters));
            matcher.appendReplacement(builder, requested != null ? requested : matcher.group(0));
        } while (matcher.find());
        return matcher.appendTail(builder).toString();
    }
}

