/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.player;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.Openable;
import io.github.pronze.lib.screaminglib.container.PlayerContainer;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityHuman;
import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.event.entity.SEntityDamageEvent;
import io.github.pronze.lib.screaminglib.particle.ParticleHolder;
import io.github.pronze.lib.screaminglib.player.OfflinePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.SenderWrapper;
import io.github.pronze.lib.screaminglib.player.gamemode.GameModeHolder;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.weather.WeatherHolder;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlayerWrapper
extends SenderWrapper,
OfflinePlayerWrapper,
EntityHuman {
    public boolean isSprinting();

    public void setSprinting(boolean var1);

    public boolean isFlying();

    public void setFlying(boolean var1);

    public boolean isAllowFlight();

    public void setAllowFlight(boolean var1);

    public boolean isSneaking();

    public void setSneaking(boolean var1);

    public int getPing();

    @Nullable
    public Component getPlayerListName();

    public void setPlayerListName(@Nullable Component var1);

    public void setPlayerListName(@Nullable ComponentLike var1);

    @NotNull
    public Component getDisplayName();

    public void setDisplayName(@Nullable Component var1);

    public void setDisplayName(@Nullable ComponentLike var1);

    public Container getEnderChest();

    public PlayerContainer getPlayerInventory();

    public Optional<Container> getOpenedInventory();

    public void openInventory(Openable var1);

    public void closeInventory();

    public void kick(Component var1);

    public void kick(ComponentLike var1);

    public GameModeHolder getGameMode();

    public void setGameMode(@NotNull GameModeHolder var1);

    public int getLevel();

    public float getExp();

    public void setLevel(int var1);

    public void setExp(float var1);

    public void forceUpdateInventory();

    public Optional<WeatherHolder> getPlayerWeather();

    public void setPlayerWeather(@Nullable WeatherHolder var1);

    public long getPlayerTime();

    public void setPlayerTime(long var1, boolean var3);

    public void resetPlayerTime();

    public void sendParticle(ParticleHolder var1, LocationHolder var2);

    public LocationHolder getCompassTarget();

    public void setCompassTarget(LocationHolder var1);

    public void restoreDefaultScoreboard();

    public Optional<EntityBasic> getSpectatorTarget();

    public void setSpectatorTarget(@Nullable EntityBasic var1);

    public Channel getChannel();

    public int getProtocolVersion();

    public InetSocketAddress getAddress();

    default public void launch(double multiply, double y) {
        if (this.isOnline()) {
            this.setVelocity(this.getVelocity().multiply(multiply).setY(y));
            EventManager.getDefaultEventManager().registerOneTime(SEntityDamageEvent.class, event -> {
                if (!(event.entity() instanceof PlayerWrapper && this.equals(event.entity()) && event.damageCause().is((Object)"FALL"))) {
                    return false;
                }
                event.cancelled(true);
                return true;
            });
        }
    }

    default public void launch(Vector3D velocity) {
        if (this.isOnline()) {
            this.setVelocity(velocity);
            EventManager.getDefaultEventManager().registerOneTime(SEntityDamageEvent.class, event -> {
                if (!(event.entity() instanceof PlayerWrapper && this.equals(event.entity()) && event.damageCause().is((Object)"FALL"))) {
                    return false;
                }
                event.cancelled(true);
                return true;
            });
        }
    }

    @Override
    default public CommandSenderWrapper.Type getType() {
        return CommandSenderWrapper.Type.PLAYER;
    }

    public static enum Hand implements Wrapper
    {
        MAIN,
        OFF;


        @Override
        public <T> T as(Class<T> type) {
            return PlayerMapper.convertHand(this, type);
        }
    }
}

