/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.player.gamemode;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.GameModeHolderSerializer;
import io.github.pronze.lib.screaminglib.player.gamemode.GameModeHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class GameModeMapping
extends AbstractTypeMapper<GameModeHolder> {
    private static GameModeMapping gameModeMapping;
    protected final BidirectionalConverter<GameModeHolder> gameModeConverter = BidirectionalConverter.build().registerP2W(GameModeHolder.class, g -> g).registerP2W(ConfigurationNode.class, node -> {
        try {
            return GameModeHolderSerializer.INSTANCE.deserialize((Type)((Object)GameModeHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public GameModeMapping() {
        if (gameModeMapping != null) {
            throw new UnsupportedOperationException("GameModeMapping is already initialized!");
        }
        gameModeMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_MODE)
    @OfMethodAlternative(value=GameModeHolder.class, methodName="ofOptional")
    public static Optional<GameModeHolder> resolve(Object gameMode) {
        if (gameModeMapping == null) {
            throw new UnsupportedOperationException("GameModeMapping is not initialized yet.");
        }
        if (gameMode == null) {
            return Optional.empty();
        }
        return GameModeMapping.gameModeMapping.gameModeConverter.convertOptional(gameMode).or(() -> gameModeMapping.resolveFromMapping(gameMode));
    }

    @OfMethodAlternative(value=GameModeHolder.class, methodName="all")
    public static List<GameModeHolder> getValues() {
        if (gameModeMapping == null) {
            throw new UnsupportedOperationException("GameModeMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(GameModeMapping.gameModeMapping.values);
    }
}

