/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.plugin;

import io.github.pronze.lib.screaminglib.plugin.PluginDescription;
import io.github.pronze.lib.screaminglib.plugin.PluginKey;
import io.github.pronze.lib.screaminglib.utils.PlatformType;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class PluginManager {
    private static PluginManager pluginManager;

    @ApiStatus.Internal
    public static void init(Supplier<PluginManager> supplier) {
        if (pluginManager != null) {
            throw new UnsupportedOperationException("PluginManager is already initialized.");
        }
        pluginManager = supplier.get();
    }

    public static Optional<Object> getPlatformClass(PluginKey pluginKey) {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.getPlatformClass0(pluginKey);
    }

    protected abstract Optional<Object> getPlatformClass0(PluginKey var1);

    public static boolean isEnabled(PluginKey pluginKey) {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.isEnabled0(pluginKey);
    }

    protected abstract boolean isEnabled0(PluginKey var1);

    public static Optional<PluginDescription> getPlugin(PluginKey pluginKey) {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.getPlugin0(pluginKey);
    }

    protected abstract Optional<PluginDescription> getPlugin0(PluginKey var1);

    public static List<PluginDescription> getAllPlugins() {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.getAllPlugins0();
    }

    protected abstract List<PluginDescription> getAllPlugins0();

    public static Optional<PluginKey> createKey(Object identifier) {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.createKey0(identifier);
    }

    protected abstract Optional<PluginKey> createKey0(Object var1);

    public static PlatformType getPlatformType() {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.getPlatformType0();
    }

    protected abstract PlatformType getPlatformType0();

    public static Optional<PluginDescription> getPluginFromPlatformObject(Object object) {
        if (pluginManager == null) {
            throw new UnsupportedOperationException("PluginManager is not initialized yet.");
        }
        return pluginManager.getPluginFromPlatformObject0(object);
    }

    protected abstract Optional<PluginDescription> getPluginFromPlatformObject0(Object var1);
}

