/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.sidebar;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetDisplayObjectivePacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetObjectivePacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetPlayerTeamPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetScorePacket;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.SenderMessage;
import io.github.pronze.lib.screaminglib.sender.StaticSenderMessage;
import io.github.pronze.lib.screaminglib.sidebar.ScoreSidebar;
import io.github.pronze.lib.screaminglib.sidebar.SidebarManager;
import io.github.pronze.lib.screaminglib.sidebar.team.ScoreboardTeam;
import io.github.pronze.lib.screaminglib.sidebar.team.ScoreboardTeamImpl;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.data.DataContainer;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractVisual;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class ScoreSidebarImpl
extends AbstractVisual<ScoreSidebar>
implements ScoreSidebar {
    protected final List<ScoreboardTeam> teams = new LinkedList<ScoreboardTeam>();
    protected final List<ScoreEntry> entries = new CopyOnWriteArrayList<ScoreEntry>();
    protected DataContainer data;
    protected boolean ready;
    protected SenderMessage title = SenderMessage.empty();
    private final String objectiveKey;
    private final List<ScoreEntry> lines = new CopyOnWriteArrayList<ScoreEntry>();

    public ScoreSidebarImpl(UUID uuid) {
        super(uuid);
        this.objectiveKey = new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public Optional<ScoreboardTeam> getTeam(String identifier) {
        return this.teams.stream().filter(scoreboardTeam -> identifier.equals(scoreboardTeam.identifier())).findFirst();
    }

    @Override
    public ScoreSidebar removeTeam(String identifier) {
        this.getTeam(identifier).ifPresent(this::removeTeam);
        return this;
    }

    @Override
    public ScoreSidebar removeTeam(ScoreboardTeam scoreboardTeam) {
        scoreboardTeam.destroy();
        this.teams.remove(scoreboardTeam);
        return this;
    }

    @Override
    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return !this.data.isEmpty();
    }

    @Override
    public ScoreSidebar title(Component title) {
        return this.title(SenderMessage.of(title));
    }

    @Override
    public ScoreSidebar title(ComponentLike title) {
        this.title = title instanceof SenderMessage ? (SenderMessage)title : SenderMessage.of(title);
        this.updateTitle0();
        return this;
    }

    @Override
    public ScoreSidebar entity(String identifier, Component displayName) {
        this.entries.stream().filter(entryA -> entryA.getIdentifier().equals(identifier)).findFirst().ifPresentOrElse(scoreEntry -> {
            if (!displayName.equals(scoreEntry.getComponent())) {
                scoreEntry.setComponent(displayName);
                scoreEntry.setReloadCache(true);
                this.update();
            }
        }, () -> {
            ScoreEntry scoreEntry = new ScoreEntry(identifier);
            scoreEntry.setComponent(displayName);
            this.entries.add(scoreEntry);
            this.update();
        });
        return this;
    }

    @Override
    public ScoreSidebar score(String identifier, int score) {
        this.entries.stream().filter(entryA -> entryA.getIdentifier().equals(identifier)).findFirst().ifPresent(scoreEntry -> {
            scoreEntry.setScore(score);
            this.update();
        });
        return this;
    }

    @Override
    public ScoreSidebar removeEntity(String identifier) {
        this.entries.stream().filter(entryA -> entryA.getIdentifier().equals(identifier)).findFirst().ifPresent(scoreEntry -> {
            this.entries.remove(scoreEntry);
            this.update();
        });
        return this;
    }

    @Override
    public ScoreSidebar update() {
        if (this.ready) {
            this.update0();
        }
        return this;
    }

    @Override
    public ScoreSidebar show() {
        if (this.shown()) {
            return this;
        }
        this.ready = true;
        this.visible = true;
        this.viewers.forEach(a -> this.onViewerAdded((PlayerWrapper)a, false));
        this.update();
        return this;
    }

    @Override
    public ScoreSidebar hide() {
        if (!this.shown()) {
            return this;
        }
        this.visible = false;
        this.ready = false;
        this.update();
        return this;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.hide();
        this.viewers.clear();
        SidebarManager.removeSidebar(this);
    }

    @Override
    public void onViewerAdded(PlayerWrapper player, boolean checkDistance) {
        if (this.visible) {
            this.getCreateObjectivePacket(player).sendPacket(player);
            this.allScores().forEach(packet -> packet.sendPacket(player));
            this.getDisplayObjectivePacket().sendPacket(player);
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructCreatePacket().sendPacket(player));
        }
    }

    @Override
    public void onViewerRemoved(PlayerWrapper player, boolean checkDistance) {
        if (this.visible && player.isOnline()) {
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructDestructPacket().sendPacket(player));
            this.getDestroyObjectivePacket().sendPacket(player);
        }
    }

    private SClientboundSetObjectivePacket getCreateObjectivePacket(PlayerWrapper player) {
        SClientboundSetObjectivePacket packet = this.notFinalObjectivePacket(player);
        packet.mode(SClientboundSetObjectivePacket.Mode.CREATE);
        return packet;
    }

    private SClientboundSetObjectivePacket getUpdateObjectivePacket(PlayerWrapper player) {
        SClientboundSetObjectivePacket packet = this.notFinalObjectivePacket(player);
        packet.mode(SClientboundSetObjectivePacket.Mode.UPDATE);
        return packet;
    }

    private SClientboundSetObjectivePacket notFinalObjectivePacket(PlayerWrapper player) {
        return new SClientboundSetObjectivePacket().objectiveKey(this.objectiveKey).title(this.title.asComponent(player)).criteriaType(SClientboundSetObjectivePacket.Type.INTEGER);
    }

    private SClientboundSetObjectivePacket getDestroyObjectivePacket() {
        return new SClientboundSetObjectivePacket().objectiveKey(this.objectiveKey).mode(SClientboundSetObjectivePacket.Mode.DESTROY);
    }

    private SClientboundSetDisplayObjectivePacket getDisplayObjectivePacket() {
        return new SClientboundSetDisplayObjectivePacket().slot(SClientboundSetDisplayObjectivePacket.DisplaySlot.SIDEBAR).objectiveKey(this.objectiveKey);
    }

    private SClientboundSetScorePacket createScorePacket(int i, String value) {
        return new SClientboundSetScorePacket().entityName(value).objectiveKey(this.objectiveKey).score(i).action(SClientboundSetScorePacket.ScoreboardAction.CHANGE);
    }

    private SClientboundSetScorePacket destroyScore(String value) {
        return new SClientboundSetScorePacket().entityName(value).objectiveKey(this.objectiveKey).action(SClientboundSetScorePacket.ScoreboardAction.REMOVE);
    }

    private List<SClientboundSetScorePacket> allScores() {
        return this.lines.stream().map(entry -> this.createScorePacket(entry.getScore(), entry.getCache())).collect(Collectors.toList());
    }

    public String crop(String baseLine) {
        if (baseLine.length() > 40) {
            return baseLine.substring(0, 40);
        }
        return baseLine;
    }

    @Override
    public ScoreboardTeam team(String identifier) {
        ScoreboardTeamImpl team = new ScoreboardTeamImpl(this, identifier);
        this.teams.add(team);
        if (this.visible && !this.viewers.isEmpty()) {
            SClientboundSetPlayerTeamPacket packet = team.constructCreatePacket();
            this.viewers.forEach(packet::sendPacket);
        }
        return team;
    }

    protected void updateTitle0() {
        if (this.visible && !this.viewers.isEmpty()) {
            this.viewers.forEach(p -> this.getUpdateObjectivePacket((PlayerWrapper)p).sendPacket((PlayerWrapper)p));
        }
    }

    @Override
    protected void update0() {
        List<ScoreEntry> list = this.entries.stream().sorted(Comparator.comparingInt(ScoreEntry::getScore).reversed()).limit(15L).collect(Collectors.toList());
        ArrayList packets = new ArrayList();
        this.lines.stream().filter(scoreEntry -> !list.contains(scoreEntry)).forEach(scoreEntry -> {
            this.lines.remove(scoreEntry);
            packets.add(this.destroyScore(scoreEntry.getCache()));
        });
        list.forEach(scoreEntry -> {
            if (!this.lines.contains(scoreEntry)) {
                this.lines.add((ScoreEntry)scoreEntry);
            }
            if (scoreEntry.getCache() == null || scoreEntry.isReloadCache()) {
                if (scoreEntry.getCache() != null) {
                    packets.add(this.destroyScore(scoreEntry.getCache()));
                }
                scoreEntry.setCache(this.crop(AdventureHelper.toLegacy(scoreEntry.getComponent())));
                scoreEntry.setReloadCache(false);
            }
            packets.add(this.createScorePacket(scoreEntry.getScore(), scoreEntry.getCache()));
        });
        if (this.visible) {
            this.viewers.forEach(viewer -> packets.forEach(packet -> packet.sendPacket((PlayerWrapper)viewer)));
        }
        if (!(this.title instanceof StaticSenderMessage)) {
            this.updateTitle0();
        }
    }

    public List<ScoreboardTeam> getTeams() {
        return this.teams;
    }

    public List<ScoreEntry> getEntries() {
        return this.entries;
    }

    @Override
    public DataContainer data() {
        return this.data;
    }

    @Override
    public ScoreSidebarImpl data(DataContainer data) {
        this.data = data;
        return this;
    }

    public static class ScoreEntry {
        private final String identifier;
        private Component component;
        private int score;
        private String cache;
        private boolean reloadCache;

        public ScoreEntry(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Component getComponent() {
            return this.component;
        }

        public int getScore() {
            return this.score;
        }

        public String getCache() {
            return this.cache;
        }

        public boolean isReloadCache() {
            return this.reloadCache;
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        public void setScore(int score) {
            this.score = score;
        }

        public void setCache(String cache) {
            this.cache = cache;
        }

        public void setReloadCache(boolean reloadCache) {
            this.reloadCache = reloadCache;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScoreEntry)) {
                return false;
            }
            ScoreEntry other = (ScoreEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getScore() != other.getScore()) {
                return false;
            }
            if (this.isReloadCache() != other.isReloadCache()) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Component this$component = this.getComponent();
            Component other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            String this$cache = this.getCache();
            String other$cache = other.getCache();
            return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScoreEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getScore();
            result = result * 59 + (this.isReloadCache() ? 79 : 97);
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Component $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            String $cache = this.getCache();
            result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
            return result;
        }

        public String toString() {
            return "ScoreSidebarImpl.ScoreEntry(identifier=" + this.getIdentifier() + ", component=" + this.getComponent() + ", score=" + this.getScore() + ", cache=" + this.getCache() + ", reloadCache=" + this.isReloadCache() + ")";
        }
    }
}

