/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.sidebar;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetDisplayObjectivePacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetObjectivePacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetPlayerTeamPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetScorePacket;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.SenderMessage;
import io.github.pronze.lib.screaminglib.sender.StaticSenderMessage;
import io.github.pronze.lib.screaminglib.sidebar.Sidebar;
import io.github.pronze.lib.screaminglib.sidebar.SidebarManager;
import io.github.pronze.lib.screaminglib.sidebar.team.ScoreboardTeam;
import io.github.pronze.lib.screaminglib.sidebar.team.ScoreboardTeamImpl;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.data.DataContainer;
import io.github.pronze.lib.screaminglib.utils.visual.SimpleCLTextEntry;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractLinedVisual;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SidebarImpl
extends AbstractLinedVisual<Sidebar>
implements Sidebar {
    protected final List<ScoreboardTeam> teams = new LinkedList<ScoreboardTeam>();
    protected DataContainer data;
    protected boolean ready;
    protected SenderMessage title = SenderMessage.empty();
    private final String objectiveKey;
    private final ConcurrentSkipListMap<UUID, ConcurrentSkipListMap<Integer, String>> lines = new ConcurrentSkipListMap();

    public SidebarImpl(UUID uuid) {
        super(uuid);
        this.objectiveKey = new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public Optional<ScoreboardTeam> getTeam(String identifier) {
        return this.teams.stream().filter(scoreboardTeam -> identifier.equals(scoreboardTeam.identifier())).findFirst();
    }

    @Override
    public Sidebar removeTeam(String identifier) {
        this.getTeam(identifier).ifPresent(this::removeTeam);
        return this;
    }

    @Override
    public Sidebar removeTeam(ScoreboardTeam scoreboardTeam) {
        scoreboardTeam.destroy();
        this.teams.remove(scoreboardTeam);
        return this;
    }

    @Override
    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return !this.data.isEmpty();
    }

    @Override
    public Sidebar title(Component title) {
        return this.title(SenderMessage.of(title));
    }

    @Override
    public Sidebar title(ComponentLike title) {
        this.title = title instanceof SenderMessage ? (SenderMessage)title : SenderMessage.of(title);
        this.updateTitle0();
        return this;
    }

    @Override
    public Sidebar update() {
        if (this.ready) {
            this.update0();
        }
        return this;
    }

    @Override
    public Sidebar show() {
        if (this.shown()) {
            return this;
        }
        this.ready = true;
        this.visible = true;
        this.viewers.forEach(a -> this.onViewerAdded((PlayerWrapper)a, false));
        this.update();
        return this;
    }

    @Override
    public Sidebar hide() {
        if (!this.shown()) {
            return this;
        }
        this.visible = false;
        this.ready = false;
        this.update();
        return this;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.hide();
        this.viewers.clear();
        SidebarManager.removeSidebar(this);
    }

    @Override
    public void onViewerAdded(PlayerWrapper player, boolean checkDistance) {
        if (this.visible) {
            this.getCreateObjectivePacket(player).sendPacket(player);
            this.updateForPlayer(player);
            this.getDisplayObjectivePacket().sendPacket(player);
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructCreatePacket().sendPacket(player));
        }
    }

    @Override
    public void onViewerRemoved(PlayerWrapper player, boolean checkDistance) {
        if (this.visible && player.isOnline()) {
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructDestructPacket().sendPacket(player));
            this.getDestroyObjectivePacket().sendPacket(player);
        }
    }

    @Override
    protected void update0() {
        List.copyOf(this.viewers).forEach(this::updateForPlayer);
    }

    private void updateForPlayer(PlayerWrapper playerWrapper) {
        ConcurrentSkipListMap<Integer, String> lines = this.lines.get(playerWrapper.getUuid());
        if (lines == null) {
            lines = new ConcurrentSkipListMap();
            this.lines.put(playerWrapper.getUuid(), lines);
        }
        List<String> list = this.lines().entrySet().stream().filter(entry -> (Integer)entry.getKey() >= 0 && (Integer)entry.getKey() <= 15).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(textEntry -> {
            ComponentLike like;
            if (textEntry instanceof SimpleCLTextEntry && (like = ((SimpleCLTextEntry)textEntry).getComponentLike()) instanceof SenderMessage) {
                return ((SenderMessage)like).asComponentList(playerWrapper);
            }
            return textEntry.getText();
        }).flatMap(o -> {
            if (o instanceof List) {
                return ((List)o).stream();
            }
            return Stream.of((Component)o);
        }).map(AdventureHelper::toLegacy).collect(Collectors.toList());
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.makeUnique((String)list.get(i), list));
        }
        ArrayList<AbstractPacket> packets = new ArrayList<AbstractPacket>();
        if (!(this.title instanceof StaticSenderMessage)) {
            packets.add(this.getUpdateObjectivePacket(playerWrapper));
        }
        ArrayList<Integer> forRemoval = new ArrayList<Integer>();
        for (int i = 0; i < 15; ++i) {
            if (i < list.size()) {
                if (lines.containsKey(i)) {
                    packets.add(this.destroyScore(lines.get(i)));
                }
                lines.put(i, list.get(i));
                packets.add(this.getCreateScorePacket(i, list.get(i)));
                continue;
            }
            if (!lines.containsKey(i)) continue;
            packets.add(this.destroyScore(lines.get(i)));
            forRemoval.add(i);
        }
        forRemoval.forEach(lines::remove);
        packets.forEach(packet -> packet.sendPacket(playerWrapper));
    }

    public void updateTitle0() {
        if (this.visible && !this.viewers.isEmpty()) {
            this.viewers.forEach(p -> this.getUpdateObjectivePacket((PlayerWrapper)p).sendPacket((PlayerWrapper)p));
        }
    }

    private SClientboundSetObjectivePacket getCreateObjectivePacket(PlayerWrapper player) {
        SClientboundSetObjectivePacket packet = this.getNotFinalObjectivePacket(player);
        packet.mode(SClientboundSetObjectivePacket.Mode.CREATE);
        return packet;
    }

    private SClientboundSetObjectivePacket getUpdateObjectivePacket(PlayerWrapper player) {
        SClientboundSetObjectivePacket packet = this.getNotFinalObjectivePacket(player);
        packet.mode(SClientboundSetObjectivePacket.Mode.UPDATE);
        return packet;
    }

    private SClientboundSetObjectivePacket getNotFinalObjectivePacket(PlayerWrapper player) {
        return new SClientboundSetObjectivePacket().objectiveKey(this.objectiveKey).title(this.title.asComponent(player)).criteriaType(SClientboundSetObjectivePacket.Type.INTEGER);
    }

    private SClientboundSetObjectivePacket getDestroyObjectivePacket() {
        return new SClientboundSetObjectivePacket().objectiveKey(this.objectiveKey).mode(SClientboundSetObjectivePacket.Mode.DESTROY);
    }

    private SClientboundSetDisplayObjectivePacket getDisplayObjectivePacket() {
        return new SClientboundSetDisplayObjectivePacket().objectiveKey(this.objectiveKey).slot(SClientboundSetDisplayObjectivePacket.DisplaySlot.SIDEBAR);
    }

    private SClientboundSetScorePacket getCreateScorePacket(int i, String value) {
        return new SClientboundSetScorePacket().entityName(value).objectiveKey(this.objectiveKey).score(i).action(SClientboundSetScorePacket.ScoreboardAction.CHANGE);
    }

    private SClientboundSetScorePacket destroyScore(String value) {
        return new SClientboundSetScorePacket().entityName(value).objectiveKey(this.objectiveKey).action(SClientboundSetScorePacket.ScoreboardAction.REMOVE);
    }

    public String makeUnique(String toUnique, List<String> from) {
        if (toUnique == null) {
            toUnique = " ";
        }
        StringBuilder stringBuilder = new StringBuilder(toUnique);
        while (from.contains(stringBuilder.toString())) {
            stringBuilder.append(" ");
        }
        if (stringBuilder.length() > 40) {
            return stringBuilder.substring(0, 40);
        }
        return stringBuilder.toString();
    }

    @Override
    public ScoreboardTeam team(String identifier) {
        ScoreboardTeamImpl team = new ScoreboardTeamImpl(this, identifier);
        this.teams.add(team);
        if (this.visible && !this.viewers.isEmpty()) {
            SClientboundSetPlayerTeamPacket packet = team.constructCreatePacket();
            this.viewers.forEach(packet::sendPacket);
        }
        return team;
    }

    public List<ScoreboardTeam> getTeams() {
        return this.teams;
    }

    @Override
    public DataContainer data() {
        return this.data;
    }

    @Override
    public SidebarImpl data(DataContainer data) {
        this.data = data;
        return this;
    }
}

