/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.sidebar;

import io.github.pronze.lib.screaminglib.Core;
import io.github.pronze.lib.screaminglib.packet.PacketMapper;
import io.github.pronze.lib.screaminglib.sidebar.ScoreSidebar;
import io.github.pronze.lib.screaminglib.sidebar.ScoreSidebarImpl;
import io.github.pronze.lib.screaminglib.sidebar.Sidebar;
import io.github.pronze.lib.screaminglib.sidebar.SidebarImpl;
import io.github.pronze.lib.screaminglib.sidebar.TeamedSidebar;
import io.github.pronze.lib.screaminglib.utils.Controllable;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.visuals.Visual;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@Service(dependsOn={Core.class, PacketMapper.class})
public class SidebarManager {
    private static SidebarManager manager;
    protected final Map<UUID, TeamedSidebar<?>> activeSidebars = new HashMap();

    @Deprecated
    public SidebarManager(Controllable controllable) {
        if (manager != null) {
            throw new UnsupportedOperationException("SidebarManager is already initialized!");
        }
        manager = this;
        controllable.disable(this::destroy);
    }

    public static Map<UUID, TeamedSidebar<?>> getActiveSidebars() {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        return Map.copyOf(SidebarManager.manager.activeSidebars);
    }

    public static <T extends TeamedSidebar<T>> Optional<TeamedSidebar<T>> getSidebar(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        return Optional.ofNullable(SidebarManager.manager.activeSidebars.get(uuid));
    }

    public static void addSidebar(TeamedSidebar<?> sidebar) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        SidebarManager.manager.activeSidebars.put(sidebar.uuid(), sidebar);
    }

    public static void removeSidebar(UUID uuid) {
        SidebarManager.getSidebar(uuid).ifPresent(SidebarManager::removeSidebar);
    }

    public static void removeSidebar(TeamedSidebar<?> scoreboard) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        SidebarManager.manager.activeSidebars.remove(scoreboard.uuid());
    }

    public static Sidebar sidebar() {
        return SidebarManager.sidebar(UUID.randomUUID());
    }

    public static ScoreSidebar scoreboard() {
        return SidebarManager.scoreboard(UUID.randomUUID());
    }

    public static Sidebar sidebar(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        Sidebar scoreboard = manager.sidebar0(uuid);
        SidebarManager.addSidebar(scoreboard);
        return scoreboard;
    }

    public static ScoreSidebar scoreboard(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        ScoreSidebar scoreboard = manager.scoreSidebar0(uuid);
        SidebarManager.addSidebar(scoreboard);
        return scoreboard;
    }

    protected Sidebar sidebar0(UUID uuid) {
        return new SidebarImpl(uuid);
    }

    protected ScoreSidebar scoreSidebar0(UUID uuid) {
        return new ScoreSidebarImpl(uuid);
    }

    protected void destroy() {
        Map.copyOf(SidebarManager.getActiveSidebars()).values().forEach(Visual::destroy);
        SidebarManager.manager.activeSidebars.clear();
    }
}

