/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.sidebar.team;

import io.github.pronze.lib.kyori.adventure.audience.Audience;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetPlayerTeamPacket;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.sidebar.TeamedSidebar;
import io.github.pronze.lib.screaminglib.sidebar.team.ScoreboardTeam;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ScoreboardTeamImpl
implements ScoreboardTeam {
    protected final TeamedSidebar<?> scoreboard;
    protected final String identifier;
    protected NamedTextColor color = NamedTextColor.WHITE;
    protected Component displayName = Component.empty();
    protected Component teamPrefix = Component.empty();
    protected Component teamSuffix = Component.empty();
    protected boolean friendlyFire = true;
    protected boolean seeInvisible = true;
    protected SClientboundSetPlayerTeamPacket.TagVisibility nameTagVisibility = SClientboundSetPlayerTeamPacket.TagVisibility.ALWAYS;
    protected SClientboundSetPlayerTeamPacket.CollisionRule collisionRule = SClientboundSetPlayerTeamPacket.CollisionRule.ALWAYS;
    protected final List<PlayerWrapper> players = new LinkedList<PlayerWrapper>();
    private final String teamKey;

    public ScoreboardTeamImpl(TeamedSidebar<?> scoreboard, String identifier) {
        this.scoreboard = scoreboard;
        this.identifier = identifier;
        this.teamKey = new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public ScoreboardTeam color(NamedTextColor color) {
        this.color = color;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam displayName(Component displayName) {
        this.displayName = displayName;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam teamPrefix(Component teamPrefix) {
        this.teamPrefix = teamPrefix;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam teamSuffix(Component teamSuffix) {
        this.teamSuffix = teamSuffix;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam friendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam seeInvisible(boolean seeInvisible) {
        this.seeInvisible = seeInvisible;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam nameTagVisibility(SClientboundSetPlayerTeamPacket.TagVisibility nameTagVisibility) {
        this.nameTagVisibility = nameTagVisibility;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam collisionRule(SClientboundSetPlayerTeamPacket.CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam player(PlayerWrapper player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.sendAddPlayer(player);
        }
        return this;
    }

    @Override
    public ScoreboardTeam removePlayer(PlayerWrapper player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.sendRemovePlayer(player);
        }
        return this;
    }

    @Override
    public List<PlayerWrapper> players() {
        return List.copyOf(this.players);
    }

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.players();
    }

    public SClientboundSetPlayerTeamPacket constructDestructPacket() {
        return this.getNotFinalScoreboardTeamPacket(SClientboundSetPlayerTeamPacket.Mode.REMOVE);
    }

    private SClientboundSetPlayerTeamPacket getNotFinalScoreboardTeamPacket(SClientboundSetPlayerTeamPacket.Mode mode) {
        return new SClientboundSetPlayerTeamPacket().teamKey(this.teamKey).mode(mode);
    }

    public SClientboundSetPlayerTeamPacket constructCreatePacket() {
        SClientboundSetPlayerTeamPacket packet = this.getNotFinalScoreboardTeamPacket(SClientboundSetPlayerTeamPacket.Mode.CREATE);
        this.packInfo(packet);
        this.packPlayers(packet, this.players);
        return packet;
    }

    private void packInfo(SClientboundSetPlayerTeamPacket packet) {
        packet.displayName(this.displayName).friendlyFire(this.friendlyFire).seeInvisible(this.seeInvisible).tagVisibility(this.nameTagVisibility).collisionRule(this.collisionRule).teamColor(this.color).teamPrefix(this.teamPrefix).teamSuffix(this.teamSuffix);
    }

    private void packPlayers(SClientboundSetPlayerTeamPacket packet, List<PlayerWrapper> players) {
        packet.entities(players.stream().map(CommandSenderWrapper::getName).collect(Collectors.toList()));
    }

    protected void updateInfo() {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            SClientboundSetPlayerTeamPacket packet = this.getNotFinalScoreboardTeamPacket(SClientboundSetPlayerTeamPacket.Mode.UPDATE);
            this.packInfo(packet);
            this.scoreboard.viewers().forEach(packet::sendPacket);
        }
    }

    protected void sendAddPlayer(PlayerWrapper player) {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            SClientboundSetPlayerTeamPacket packet = this.getNotFinalScoreboardTeamPacket(SClientboundSetPlayerTeamPacket.Mode.ADD_ENTITY);
            this.packPlayers(packet, List.of(player));
            this.scoreboard.viewers().forEach(packet::sendPacket);
        }
    }

    protected void sendRemovePlayer(PlayerWrapper player) {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            SClientboundSetPlayerTeamPacket packet = this.getNotFinalScoreboardTeamPacket(SClientboundSetPlayerTeamPacket.Mode.REMOVE_ENTITY);
            this.packPlayers(packet, List.of(player));
            this.scoreboard.viewers().forEach(packet::sendPacket);
        }
    }

    @Override
    public void destroy() {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            SClientboundSetPlayerTeamPacket packet = this.constructDestructPacket();
            this.scoreboard.viewers().forEach(packet::sendPacket);
        }
    }

    public TeamedSidebar<?> scoreboard() {
        return this.scoreboard;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public NamedTextColor color() {
        return this.color;
    }

    @Override
    public Component displayName() {
        return this.displayName;
    }

    @Override
    public Component teamPrefix() {
        return this.teamPrefix;
    }

    @Override
    public Component teamSuffix() {
        return this.teamSuffix;
    }

    @Override
    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    @Override
    public boolean seeInvisible() {
        return this.seeInvisible;
    }

    @Override
    public SClientboundSetPlayerTeamPacket.TagVisibility nameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    public SClientboundSetPlayerTeamPacket.CollisionRule collisionRule() {
        return this.collisionRule;
    }

    public String teamKey() {
        return this.teamKey;
    }
}

