/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.tasker;

import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.tasker.initializer.AbstractTaskInitializer;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import io.github.pronze.lib.screaminglib.utils.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class TaskBuilderImpl
implements Tasker.TaskBuilder {
    private final Runnable runnable;
    private final AbstractTaskInitializer initializer;
    private final Integer taskId;
    private final List<Consumer<TaskerTask>> startEvent = new LinkedList<Consumer<TaskerTask>>();
    private final List<Consumer<TaskerTask>> stopEvent = new LinkedList<Consumer<TaskerTask>>();
    private boolean afterOneTick = false;
    private boolean async = false;
    private long delay;
    private long repeat;
    private TaskerTime timeUnit = TaskerTime.TICKS;

    @Override
    public Tasker.TaskBuilder afterOneTick() {
        if (this.async) {
            throw new UnsupportedOperationException("Cannot be delayed after one tick, the task is async!");
        }
        this.afterOneTick = true;
        return this;
    }

    @Override
    public Tasker.TaskBuilder async() {
        if (this.afterOneTick) {
            throw new UnsupportedOperationException("Cannot be async, the task is delayed after one tick!");
        }
        this.async = true;
        return this;
    }

    @Override
    public Tasker.TaskBuilder delay(long time, TaskerTime unit) {
        Preconditions.checkArgument(time >= 0L, "Time needs to be equals or bigger than 0!");
        this.delay = time;
        this.timeUnit = unit;
        return this;
    }

    @Override
    public Tasker.TaskBuilder repeat(long time, TaskerTime unit) {
        Preconditions.checkArgument(time >= 0L, "Time needs to be equals or bigger than 0!");
        this.repeat = time;
        this.timeUnit = unit;
        return this;
    }

    @Override
    public Tasker.TaskBuilder startEvent(Consumer<TaskerTask> handler) {
        Preconditions.checkNotNull(handler, "Handler can't be null!");
        this.startEvent.add(handler);
        return this;
    }

    @Override
    public Tasker.TaskBuilder stopEvent(Consumer<TaskerTask> handler) {
        Preconditions.checkNotNull(handler, "Handler can't be null!");
        this.stopEvent.add(handler);
        return this;
    }

    @Override
    public TaskerTask start() {
        TaskerTask task = Preconditions.checkNotNull(this.initializer.start(this), "Error occurred while trying to run task number " + this.taskId);
        Tasker.register(task);
        this.startEvent.forEach(h -> h.accept(task));
        return task;
    }

    public TaskBuilderImpl(Runnable runnable, AbstractTaskInitializer initializer, Integer taskId) {
        this.runnable = runnable;
        this.initializer = initializer;
        this.taskId = taskId;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public AbstractTaskInitializer getInitializer() {
        return this.initializer;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public List<Consumer<TaskerTask>> getStartEvent() {
        return this.startEvent;
    }

    public List<Consumer<TaskerTask>> getStopEvent() {
        return this.stopEvent;
    }

    public boolean isAfterOneTick() {
        return this.afterOneTick;
    }

    public boolean isAsync() {
        return this.async;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getRepeat() {
        return this.repeat;
    }

    public TaskerTime getTimeUnit() {
        return this.timeUnit;
    }
}

