/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.tasker;

import io.github.pronze.lib.screaminglib.utils.ProtoTaskerTime;
import java.util.concurrent.TimeUnit;

public enum TaskerTime {
    TICKS(1L, 50, TimeUnit.MILLISECONDS),
    SECONDS(20L, 1, TimeUnit.SECONDS),
    MINUTES(1200L, 1, TimeUnit.MINUTES),
    HOURS(72000L, 1, TimeUnit.HOURS);

    private final long bukkitValue;
    private final int timeUnitValue;
    private final TimeUnit timeUnit;

    private TaskerTime(long bukkitValue, int timeUnitValue, TimeUnit timeUnit) {
        this.bukkitValue = bukkitValue;
        this.timeUnitValue = timeUnitValue;
        this.timeUnit = timeUnit;
    }

    public long getBukkitTime(long multiplier) {
        return this.bukkitValue * multiplier;
    }

    public int getTime(int multiplier) {
        return this.timeUnitValue * multiplier;
    }

    public ProtoTaskerTime asProto() {
        switch (this) {
            case TICKS: {
                return ProtoTaskerTime.TICKS;
            }
            case SECONDS: {
                return ProtoTaskerTime.SECONDS;
            }
            case MINUTES: {
                return ProtoTaskerTime.MINUTES;
            }
            case HOURS: {
                return ProtoTaskerTime.HOURS;
            }
        }
        return ProtoTaskerTime.SECONDS;
    }

    public static TaskerTime from(ProtoTaskerTime wrappedTime) {
        if (wrappedTime == ProtoTaskerTime.TICKS) {
            return TICKS;
        }
        if (wrappedTime == ProtoTaskerTime.MINUTES) {
            return MINUTES;
        }
        if (wrappedTime == ProtoTaskerTime.HOURS) {
            return HOURS;
        }
        return SECONDS;
    }

    public long getBukkitValue() {
        return this.bukkitValue;
    }

    public int getTimeUnitValue() {
        return this.timeUnitValue;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

