/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ImmutableCollectionLinkedToCollection<L, O>
implements Collection<L> {
    protected final Collection<O> original;
    protected final Function<L, O> linkToOriginal;
    protected final Function<O, L> originalToLink;

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.original.contains(this.linkToOriginal.apply(o));
    }

    @Override
    @NotNull
    public Iterator<L> iterator() {
        final Iterator<O> realIterator = this.original.iterator();
        return new Iterator<L>(){

            @Override
            public boolean hasNext() {
                return realIterator.hasNext();
            }

            @Override
            public L next() {
                return ImmutableCollectionLinkedToCollection.this.originalToLink.apply(realIterator.next());
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.original.stream().map(this.originalToLink).toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.original.stream().map(this.originalToLink).toArray((int value) -> (Object[])Array.newInstance(a.getClass().getComponentType(), value));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.original.containsAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public boolean add(L e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends L> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableCollectionLinkedToCollection(Collection<O> original, Function<L, O> linkToOriginal, Function<O, L> originalToLink) {
        this.original = original;
        this.linkToOriginal = linkToOriginal;
        this.originalToLink = originalToLink;
    }
}

