/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import io.github.pronze.lib.screaminglib.utils.CollectionLinkedToCollection;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ListLinkedToList<L, O>
extends CollectionLinkedToCollection<L, O>
implements List<L> {
    public ListLinkedToList(List<O> original, Function<L, O> linkToOriginal, Function<O, L> originalToLink) {
        super(original, linkToOriginal, originalToLink);
    }

    private List<O> original() {
        return (List)this.original;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends L> c) {
        return this.original().addAll(index, c.stream().map(this.linkToOriginal).collect(Collectors.toList()));
    }

    @Override
    public L get(int index) {
        return (L)this.originalToLink.apply(this.original().get(index));
    }

    @Override
    public L set(int index, L element) {
        return (L)this.originalToLink.apply(this.original().set(index, this.linkToOriginal.apply(element)));
    }

    @Override
    public void add(int index, L element) {
        this.original().add(index, this.linkToOriginal.apply(element));
    }

    @Override
    public L remove(int index) {
        return (L)this.originalToLink.apply(this.original().remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.original().indexOf(this.linkToOriginal.apply(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.original().lastIndexOf(this.linkToOriginal.apply(o));
    }

    @Override
    @NotNull
    public ListIterator<L> listIterator() {
        final ListIterator<O> realIterator = this.original().listIterator();
        return new ListIterator<L>(){

            @Override
            public boolean hasNext() {
                return realIterator.hasNext();
            }

            @Override
            public L next() {
                return ListLinkedToList.this.originalToLink.apply(realIterator.next());
            }

            @Override
            public boolean hasPrevious() {
                return realIterator.hasPrevious();
            }

            @Override
            public L previous() {
                return ListLinkedToList.this.originalToLink.apply(realIterator.previous());
            }

            @Override
            public int nextIndex() {
                return realIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return realIterator.previousIndex();
            }

            @Override
            public void remove() {
                realIterator.remove();
            }

            @Override
            public void set(L l) {
                realIterator.set(ListLinkedToList.this.linkToOriginal.apply(l));
            }

            @Override
            public void add(L l) {
                realIterator.add(ListLinkedToList.this.linkToOriginal.apply(l));
            }
        };
    }

    @Override
    @NotNull
    public ListIterator<L> listIterator(int index) {
        final ListIterator<O> realIterator = this.original().listIterator(index);
        return new ListIterator<L>(){

            @Override
            public boolean hasNext() {
                return realIterator.hasNext();
            }

            @Override
            public L next() {
                return ListLinkedToList.this.originalToLink.apply(realIterator.next());
            }

            @Override
            public boolean hasPrevious() {
                return realIterator.hasPrevious();
            }

            @Override
            public L previous() {
                return ListLinkedToList.this.originalToLink.apply(realIterator.previous());
            }

            @Override
            public int nextIndex() {
                return realIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return realIterator.previousIndex();
            }

            @Override
            public void remove() {
                realIterator.remove();
            }

            @Override
            public void set(L l) {
                realIterator.set(ListLinkedToList.this.linkToOriginal.apply(l));
            }

            @Override
            public void add(L l) {
                realIterator.add(ListLinkedToList.this.linkToOriginal.apply(l));
            }
        };
    }

    @Override
    @NotNull
    public List<L> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

