/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import java.util.Arrays;
import java.util.stream.Collectors;

public final class StringUtils {
    public static String capitalizeFirst(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class SnakeCase
    implements Case {
        @Override
        public String toLowerCamel(String s) {
            String[] split = s.split("_");
            if (split.length == 1) {
                return s;
            }
            return split[0] + Arrays.stream(Arrays.copyOfRange(split, 1, split.length)).map(StringUtils::capitalizeFirst).collect(Collectors.joining());
        }

        @Override
        public String toSnake(String s) {
            return s;
        }

        private SnakeCase() {
        }
    }

    static class LowerCamelCase
    implements Case {
        @Override
        public String toLowerCamel(String s) {
            return s;
        }

        @Override
        public String toSnake(String s) {
            StringBuilder builder = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    builder.append("_");
                }
                builder.append(Character.toLowerCase(c));
            }
            return builder.toString();
        }

        private LowerCamelCase() {
        }
    }

    public static interface Case {
        public static final Case LOWER_CAMEL = new LowerCamelCase();
        public static final Case SNAKE = new SnakeCase();

        public String toLowerCamel(String var1);

        public String toSnake(String var1);
    }
}

