/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.inventory.Book;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Collection;

public final class BookUtils {
    public static final Class<?> NATIVE_BOOK_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "inventory", "Book"));

    public static Object bookToPlatform(Book book) {
        if (NATIVE_BOOK_CLASS.isInstance(book)) {
            return book;
        }
        return BookUtils.bookToPlatform(book, NATIVE_BOOK_CLASS, ComponentUtils.NATIVE_COMPONENT_CLASS, ComponentUtils.NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]));
    }

    public static Object bookToPlatform(Book book, Class<?> bookClass, Class<?> componentClass, Object componentSerializer) {
        return Reflect.getMethod(bookClass, "book", componentClass, componentClass, Collection.class).invokeStatic(ComponentUtils.componentToPlatform(book.title(), componentClass), ComponentUtils.componentToPlatform(book.author(), componentClass), book.pages().stream().map(component -> ComponentUtils.componentToPlatform(component, componentSerializer)).toArray());
    }

    public static Book bookFromPlatform(Object platformObject) {
        if (platformObject instanceof Book) {
            return (Book)platformObject;
        }
        return BookUtils.bookFromPlatform(platformObject, ComponentUtils.NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]), ComponentUtils.NATIVE_COMPONENT_CLASS);
    }

    public static Book bookFromPlatform(Object platformObject, Object componentSerializer, Class<?> nativeComponentClass) {
        if (platformObject instanceof Book) {
            return (Book)platformObject;
        }
        return Book.book(ComponentUtils.componentFromPlatform(Reflect.fastInvoke(platformObject, "title"), componentSerializer, nativeComponentClass), ComponentUtils.componentFromPlatform(Reflect.fastInvoke(platformObject, "author"), componentSerializer, nativeComponentClass), (Component[])Reflect.fastInvokeResulted(platformObject, "pages").as(Collection.class).stream().map(o -> ComponentUtils.componentFromPlatform(o, componentSerializer, nativeComponentClass)).toArray(Component[]::new));
    }

    private BookUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

