/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.bossbar.BossBar;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.InvocationResult;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class BossBarUtils {
    public static final Class<?> NATIVE_BOSSBAR_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "bossbar", "BossBar"));
    public static final Class<?> NATIVE_BOSSBAR_OVERLAY_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "bossbar", "BossBar$Overlay"));
    public static final Class<?> NATIVE_BOSSBAR_FLAG_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "bossbar", "BossBar$Flag"));
    public static final Class<?> NATIVE_BOSSBAR_COLOR_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "bossbar", "BossBar$Color"));
    private static final WeakHashMap<BossBar, Object> weakMap = new WeakHashMap();

    public static Object bossBarToPlatform(BossBar bossBar) {
        if (NATIVE_BOSSBAR_CLASS.isInstance(bossBar)) {
            return bossBar;
        }
        return BossBarUtils.bossBarToPlatform(bossBar, NATIVE_BOSSBAR_CLASS, ComponentUtils.NATIVE_COMPONENT_CLASS, ComponentUtils.NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]), NATIVE_BOSSBAR_FLAG_CLASS, NATIVE_BOSSBAR_OVERLAY_CLASS, NATIVE_BOSSBAR_COLOR_CLASS);
    }

    public static Object bossBarToPlatform(BossBar bossBar, Class<?> bossBarClass, final Class<?> componentClass, final Object componentSerializer, final Class<?> flagsClass, final Class<?> overlayClass, final Class<?> colorClass) {
        boolean nativeAdventure;
        boolean bl = nativeAdventure = componentSerializer == ComponentUtils.NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]);
        if (nativeAdventure && weakMap.containsKey(bossBar)) {
            return weakMap.get(bossBar);
        }
        final InvocationResult platformBossBar = Reflect.getMethod(bossBarClass, "name", componentClass).invokeStaticResulted(ComponentUtils.componentToPlatform(bossBar.name(), componentSerializer));
        platformBossBar.getMethod("progress", Float.TYPE).invoke(Float.valueOf(bossBar.progress()));
        platformBossBar.getMethod("color", colorClass).invoke(BossBarUtils.colorToPlatform(bossBar.color(), colorClass));
        platformBossBar.getMethod("overlay", overlayClass).invoke(BossBarUtils.overlayToPlatform(bossBar.overlay(), overlayClass));
        platformBossBar.getMethod("flags", Set.class).invoke(bossBar.flags().stream().map(flag -> BossBarUtils.flagToPlatform(flag, flagsClass)).collect(Collectors.toSet()));
        if (nativeAdventure) {
            weakMap.put(bossBar, platformBossBar.raw());
        }
        bossBar.addListener(new BossBar.Listener(){

            @Override
            public void bossBarNameChanged(@NotNull BossBar bar, @NotNull Component oldName, @NotNull Component newName) {
                platformBossBar.getMethod("name", componentClass).invoke(ComponentUtils.componentToPlatform(newName, componentSerializer));
            }

            @Override
            public void bossBarProgressChanged(@NotNull BossBar bar, float oldProgress, float newProgress) {
                platformBossBar.getMethod("progress", Float.TYPE).invoke(Float.valueOf(newProgress));
            }

            @Override
            public void bossBarColorChanged(@NotNull BossBar bar, @NotNull BossBar.Color oldColor, @NotNull BossBar.Color newColor) {
                platformBossBar.getMethod("color", colorClass).invoke(BossBarUtils.colorToPlatform(newColor, colorClass));
            }

            @Override
            public void bossBarOverlayChanged(@NotNull BossBar bar, @NotNull BossBar.Overlay oldOverlay, @NotNull BossBar.Overlay newOverlay) {
                platformBossBar.getMethod("overlay", overlayClass).invoke(BossBarUtils.overlayToPlatform(newOverlay, overlayClass));
            }

            @Override
            public void bossBarFlagsChanged(@NotNull BossBar bar, @NotNull Set<BossBar.Flag> flagsAdded, @NotNull Set<BossBar.Flag> flagsRemoved) {
                platformBossBar.getMethod("addFlags", Iterable.class).invoke(flagsAdded.stream().map(flag -> BossBarUtils.flagToPlatform(flag, flagsClass)).collect(Collectors.toSet()));
                platformBossBar.getMethod("removeFlags", Iterable.class).invoke(flagsRemoved.stream().map(flag -> BossBarUtils.flagToPlatform(flag, flagsClass)).collect(Collectors.toSet()));
            }
        });
        return platformBossBar.raw();
    }

    public static BossBar bossBarFromPlatform(Object platformObject) {
        if (platformObject instanceof BossBar) {
            return (BossBar)platformObject;
        }
        return null;
    }

    public static Object colorToPlatform(BossBar.Color color) {
        if (NATIVE_BOSSBAR_COLOR_CLASS.isInstance((Object)color)) {
            return color;
        }
        return BossBarUtils.colorToPlatform(color, NATIVE_BOSSBAR_COLOR_CLASS);
    }

    public static Object colorToPlatform(BossBar.Color color, Class<?> colorClass) {
        return Reflect.findEnumConstant(colorClass, color.name());
    }

    public static BossBar.Color colorFromPlatform(Object platformObject) {
        if (platformObject instanceof BossBar.Color) {
            return (BossBar.Color)((Object)platformObject);
        }
        return BossBar.Color.valueOf(Reflect.fastInvoke(platformObject, "name").toString());
    }

    public static Object overlayToPlatform(BossBar.Overlay overlay) {
        if (NATIVE_BOSSBAR_OVERLAY_CLASS.isInstance((Object)overlay)) {
            return overlay;
        }
        return BossBarUtils.overlayToPlatform(overlay, NATIVE_BOSSBAR_OVERLAY_CLASS);
    }

    public static Object overlayToPlatform(BossBar.Overlay overlay, Class<?> overlayClass) {
        return Reflect.findEnumConstant(overlayClass, overlay.name());
    }

    public static BossBar.Overlay overlayFromPlatform(Object platformObject) {
        if (platformObject instanceof BossBar.Overlay) {
            return (BossBar.Overlay)((Object)platformObject);
        }
        return BossBar.Overlay.valueOf(Reflect.fastInvoke(platformObject, "name").toString());
    }

    public static Object flagToPlatform(BossBar.Flag flag) {
        if (NATIVE_BOSSBAR_FLAG_CLASS.isInstance((Object)flag)) {
            return flag;
        }
        return BossBarUtils.flagToPlatform(flag, NATIVE_BOSSBAR_FLAG_CLASS);
    }

    public static Object flagToPlatform(BossBar.Flag flag, Class<?> flagClass) {
        return Reflect.findEnumConstant(flagClass, flag.name());
    }

    public static BossBar.Flag flagFromPlatform(Object platformObject) {
        if (platformObject instanceof BossBar.Flag) {
            return (BossBar.Flag)((Object)platformObject);
        }
        return BossBar.Flag.valueOf(Reflect.fastInvoke(platformObject, "name").toString());
    }

    private BossBarUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

