/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.identity.Identity;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.UUID;

public final class IdentityUtils {
    public static final Class<?> NATIVE_IDENTITY_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "identity", "Identity"));

    public static Object identityToPlatform(Identity identity) {
        if (NATIVE_IDENTITY_CLASS.isInstance(identity)) {
            return identity;
        }
        return IdentityUtils.identityToPlatform(identity, NATIVE_IDENTITY_CLASS);
    }

    public static Object identityToPlatform(Identity identity, Class<?> identityClass) {
        return Reflect.getMethod(identityClass, "identity", UUID.class).invokeStatic(identity.uuid());
    }

    public static Identity identityFromPlatform(Object platformObject) {
        if (platformObject instanceof Identity) {
            return (Identity)platformObject;
        }
        return Identity.identity(Reflect.fastInvokeResulted(platformObject, "uuid").as(UUID.class));
    }

    private IdentityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

