/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.sound.Sound;
import io.github.pronze.lib.kyori.adventure.sound.SoundStop;
import io.github.pronze.lib.screaminglib.utils.adventure.KeyUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;

public final class SoundUtils {
    public static final Class<?> NATIVE_SOUND_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "sound", "Sound"));
    public static final Class<?> NATIVE_SOURCE_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "sound", "Sound$Source"));
    public static final Class<?> NATIVE_SOUND_STOP_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "sound", "SoundStop"));

    public static Object soundToPlatform(Sound sound) {
        if (NATIVE_SOUND_CLASS.isInstance(sound)) {
            return sound;
        }
        return SoundUtils.soundToPlatform(sound, NATIVE_SOUND_CLASS, KeyUtils.NATIVE_KEY_CLASS, NATIVE_SOURCE_CLASS);
    }

    public static Object soundToPlatform(Sound sound, Class<?> soundClass, Class<?> keyClass, Class<?> sourceClass) {
        return Reflect.getMethod(soundClass, "sound", keyClass, sourceClass, Float.TYPE, Float.TYPE).invokeStatic(KeyUtils.keyToPlatform(sound.name(), soundClass), SoundUtils.sourceToPlatform(sound.source(), sourceClass), Float.valueOf(sound.volume()), Float.valueOf(sound.pitch()));
    }

    public static Sound soundFromPlatform(Object platformObject) {
        if (platformObject instanceof Sound) {
            return (Sound)platformObject;
        }
        return Sound.sound(KeyUtils.keyFromPlatform(Reflect.fastInvoke(platformObject, "name")), SoundUtils.sourceFromPlatform(Reflect.fastInvoke(platformObject, "source")), Reflect.fastInvokeResulted(platformObject, "volume").as(Float.TYPE).floatValue(), Reflect.fastInvokeResulted(platformObject, "pitch").as(Float.TYPE).floatValue());
    }

    public static Object sourceToPlatform(Sound.Source source) {
        if (NATIVE_SOURCE_CLASS.isInstance((Object)source)) {
            return source;
        }
        return SoundUtils.sourceToPlatform(source, NATIVE_SOURCE_CLASS);
    }

    public static Object sourceToPlatform(Sound.Source source, Class<?> sourceClass) {
        return Reflect.findEnumConstant(sourceClass, source.name());
    }

    public static Sound.Source sourceFromPlatform(Object platformObject) {
        if (platformObject instanceof Sound.Source) {
            return (Sound.Source)((Object)platformObject);
        }
        return Sound.Source.valueOf(Reflect.fastInvoke(platformObject, "name").toString());
    }

    public static Object stopSoundToPlatform(SoundStop soundStop) {
        if (NATIVE_SOUND_STOP_CLASS.isInstance(soundStop)) {
            return soundStop;
        }
        return SoundUtils.stopSoundToPlatform(soundStop, NATIVE_SOUND_STOP_CLASS, KeyUtils.NATIVE_KEY_CLASS, NATIVE_SOURCE_CLASS);
    }

    public static Object stopSoundToPlatform(SoundStop soundStop, Class<?> soundStopClass, Class<?> keyClass, Class<?> sourceClass) {
        if (soundStop.sound() != null && soundStop.source() != null) {
            return Reflect.getMethod(soundStopClass, "namedOnSource", keyClass, sourceClass).invokeStatic(KeyUtils.keyToPlatform(soundStop.sound(), keyClass), SoundUtils.sourceToPlatform(soundStop.source(), sourceClass));
        }
        if (soundStop.sound() != null) {
            return Reflect.getMethod(soundStopClass, "named", keyClass).invokeStatic(KeyUtils.keyToPlatform(soundStop.sound(), keyClass));
        }
        if (soundStop.source() != null) {
            return Reflect.getMethod(soundStopClass, "source", sourceClass).invokeStatic(SoundUtils.sourceToPlatform(soundStop.source(), sourceClass));
        }
        return Reflect.fastInvoke(soundStopClass, "all");
    }

    public static SoundStop stopSoundFromPlatform(Object platformObject) {
        if (platformObject instanceof SoundStop) {
            return (SoundStop)platformObject;
        }
        Object sound = Reflect.fastInvoke(platformObject, "sound");
        Object source = Reflect.fastInvoke(platformObject, "source");
        if (sound != null && source != null) {
            return SoundStop.namedOnSource(KeyUtils.keyFromPlatform(sound), SoundUtils.sourceFromPlatform(source));
        }
        if (sound != null) {
            return SoundStop.named(KeyUtils.keyFromPlatform(sound));
        }
        if (source != null) {
            return SoundStop.source(SoundUtils.sourceFromPlatform(source));
        }
        return SoundStop.all();
    }

    private SoundUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

