/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.title.Title;
import io.github.pronze.lib.kyori.adventure.title.TitlePart;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.time.Duration;

public final class TitleUtils {
    public static final Class<?> NATIVE_TITLE_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "title", "Title"));
    public static final Class<?> NATIVE_TIMES_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "title", "Title$Times"));
    public static final Class<?> NATIVE_TITLE_PART_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "title", "TitlePart"));

    public static Object timesToPlatform(Title.Times times) {
        if (NATIVE_TIMES_CLASS.isInstance(times)) {
            return times;
        }
        return TitleUtils.timesToPlatform(times, NATIVE_TIMES_CLASS);
    }

    public static Object timesToPlatform(Title.Times times, Class<?> timesClass) {
        return Reflect.getMethod(timesClass, "of", Duration.class, Duration.class, Duration.class).invokeStatic(times.fadeIn(), times.stay(), times.fadeOut());
    }

    public static Title.Times timesFromPlatform(Object platformObject) {
        if (platformObject instanceof Title.Times) {
            return (Title.Times)platformObject;
        }
        return Title.Times.of(Reflect.fastInvokeResulted(platformObject, "fadeIn").as(Duration.class), Reflect.fastInvokeResulted(platformObject, "stay").as(Duration.class), Reflect.fastInvokeResulted(platformObject, "fadeOut").as(Duration.class));
    }

    public static Object titleToPlatform(Title title) {
        if (NATIVE_TITLE_CLASS.isInstance(title)) {
            return title;
        }
        return TitleUtils.titleToPlatform(title, NATIVE_TITLE_CLASS, ComponentUtils.NATIVE_COMPONENT_CLASS, ComponentUtils.NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]), NATIVE_TIMES_CLASS);
    }

    public static Object titleToPlatform(Title title, Class<?> titleClass, Class<?> componentClass, Object componentSerializer, Class<?> timesClass) {
        return Reflect.getMethod(titleClass, "title", componentClass, componentClass, timesClass).invokeStatic(ComponentUtils.componentToPlatform(title.title(), componentSerializer), ComponentUtils.componentToPlatform(title.subtitle(), componentSerializer), title.times() != null ? TitleUtils.timesToPlatform(title.times(), timesClass) : null);
    }

    public static Title titleFromPlatform(Object platformObject) {
        if (platformObject instanceof Title) {
            return (Title)platformObject;
        }
        return Title.title(ComponentUtils.componentFromPlatform(Reflect.fastInvoke(platformObject, "title")), ComponentUtils.componentFromPlatform(Reflect.fastInvoke(platformObject, "subtitle")), TitleUtils.timesFromPlatform(Reflect.fastInvoke(platformObject, "times")));
    }

    public static Object titlePartToPlatform(TitlePart<?> part) {
        if (NATIVE_TITLE_PART_CLASS.isInstance(part)) {
            return part;
        }
        return TitleUtils.titlePartToPlatform(part, NATIVE_TITLE_PART_CLASS);
    }

    public static Object titlePartToPlatform(TitlePart<?> part, Class<?> partClass) {
        String name = part.toString();
        name = name.substring(name.indexOf(".") + 1);
        return Reflect.getField(partClass, name);
    }

    public static TitlePart<?> titlePartFromPlatform(Object platformObject) {
        if (platformObject instanceof TitlePart) {
            return (TitlePart)platformObject;
        }
        String name = platformObject.toString();
        name = name.substring(name.indexOf(".") + 1);
        return (TitlePart)Reflect.getField(TitlePart.class, name);
    }

    private TitleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

