/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import org.jetbrains.annotations.NotNull;

public final class ComponentWrapper
implements ComponentLike,
Wrapper {
    private final Component component;

    @Override
    @NotNull
    public Component asComponent() {
        return this.component;
    }

    public static ComponentWrapper of(ComponentLike component) {
        return new ComponentWrapper(component.asComponent());
    }

    @Override
    public <T> T as(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return (T)AdventureHelper.toLegacy(this.component);
        }
        if (type.isInstance(this.component)) {
            return (T)this.component;
        }
        Class gsonSerializer = Reflect.getClassSafe(type.getPackageName() + ".serializer.gson.GsonComponentSerializer");
        if (gsonSerializer == null) {
            throw new UnsupportedOperationException("Not supported! The target adventure needs to have gson serializer!");
        }
        return (T)ComponentUtils.componentToPlatform(this.component, Reflect.fastInvoke(gsonSerializer, "gson"));
    }

    public ComponentWrapper(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentWrapper)) {
            return false;
        }
        ComponentWrapper other = (ComponentWrapper)o;
        Component this$component = this.getComponent();
        Component other$component = other.getComponent();
        return !(this$component == null ? other$component != null : !this$component.equals(other$component));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        return result;
    }

    public String toString() {
        return "ComponentWrapper(component=" + this.getComponent() + ")";
    }
}

