/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.key;

import io.github.pronze.lib.screaminglib.utils.StringUtils;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributeMappingKey
extends NamespacedMappingKey {
    public static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(?:(?<namespace>[A-Za-z0-9_.\\-]*):)?((?<attributeGroup>[A-Za-z]+)\\.)?(?<key>[A-Za-z0-9_.\\-/ ]*)$");

    protected AttributeMappingKey(String namespace, String key) {
        super(namespace, key);
    }

    public static Optional<AttributeMappingKey> ofAttributeOptional(String combinedString) {
        Matcher matcher = RESOLUTION_PATTERN.matcher(combinedString);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String namespace = matcher.group("namespace") != null ? matcher.group("namespace").toLowerCase() : "minecraft";
        String attributeGroup = matcher.group("attributeGroup");
        String key = matcher.group("key").replaceAll(" ", "_");
        if (attributeGroup == null) {
            if (key.toLowerCase().startsWith("generic_") || key.toLowerCase().startsWith("horse_") || key.toLowerCase().startsWith("zombie_")) {
                String[] split1 = key.split("_", 2);
                attributeGroup = split1[0];
                key = split1[1];
            } else {
                attributeGroup = "generic";
            }
        }
        if (!key.contains("_")) {
            key = StringUtils.Case.LOWER_CAMEL.toSnake(key);
        }
        key = key.toLowerCase();
        return AttributeMappingKey.ofAttributeOptional(namespace, attributeGroup.toLowerCase() + "." + key);
    }

    public static AttributeMappingKey of(String combinedString) {
        return AttributeMappingKey.ofAttributeOptional(combinedString).orElseThrow(() -> new IllegalArgumentException(combinedString + " doesn't match validation patterns!"));
    }

    public static Optional<NamespacedMappingKey> ofOptional(String combinedString) {
        return AttributeMappingKey.ofAttributeOptional(combinedString);
    }

    public static Optional<AttributeMappingKey> ofAttributeOptional(String namespace, String key) {
        if (!VALID_NAMESPACE.matcher(namespace).matches() || !VALID_KEY.matcher(key).matches()) {
            return Optional.empty();
        }
        return Optional.of(new AttributeMappingKey(namespace, key));
    }

    public static Optional<NamespacedMappingKey> ofOptional(String namespace, String key) {
        return AttributeMappingKey.ofAttributeOptional(namespace, key);
    }

    public static AttributeMappingKey of(String namespace, String key) {
        return AttributeMappingKey.ofAttributeOptional(namespace, key).orElseThrow(() -> new IllegalArgumentException(namespace + ":" + key + " doesn't match validation patterns!"));
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof NamespacedMappingKey) {
            return super.equals(object);
        }
        AttributeMappingKey namespacedKey = AttributeMappingKey.of(object.toString());
        return this.getNamespace().equals(namespacedKey.getNamespace()) && this.getKey().equals(namespacedKey.getKey());
    }
}

