/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.mapper;

import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractTypeMapper<T extends Wrapper> {
    protected final Map<MappingKey, T> mapping = new HashMap<MappingKey, T>();
    protected final List<T> values = new LinkedList<T>();

    protected Optional<T> resolveFromMapping(Object key) {
        Optional<MappingKey> namespaced;
        Optional<MappingKey> optional = namespaced = !(key instanceof MappingKey) ? NamespacedMappingKey.ofOptional(key.toString().trim()) : Optional.of((MappingKey)key);
        if (namespaced.isPresent() && this.mapping.containsKey(namespaced.get())) {
            return Optional.ofNullable((Wrapper)this.mapping.get(namespaced.get()));
        }
        return Optional.empty();
    }

    protected void mapAlias(String mappingKey, String alias) {
        if (mappingKey == null || alias == null) {
            throw new IllegalArgumentException("Both mapping keys mustn't be null!");
        }
        NamespacedMappingKey mappingKeyNamespaced = NamespacedMappingKey.of(mappingKey);
        NamespacedMappingKey aliasNamespaced = NamespacedMappingKey.of(alias);
        if (this.mapping.containsKey(mappingKeyNamespaced) && !this.mapping.containsKey(aliasNamespaced)) {
            this.mapping.put(aliasNamespaced, (Wrapper)this.mapping.get(mappingKeyNamespaced));
        } else if (this.mapping.containsKey(aliasNamespaced) && !this.mapping.containsKey(mappingKeyNamespaced)) {
            this.mapping.put(mappingKeyNamespaced, (Wrapper)this.mapping.get(aliasNamespaced));
        }
    }
}

