/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.reflect;

import io.github.pronze.lib.screaminglib.utils.reflect.InvocationResult;
import io.github.pronze.lib.screaminglib.utils.reflect.ReflectedExecutable;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ClassMethod
implements ReflectedExecutable<ClassMethod> {
    private final Method method;
    private final BiFunction<Class<?>[], Object[], Object[]> parameterTransformer;
    private final Function<Object, Object> resultTransformer;

    public ClassMethod(Method method) {
        this(method, (classes, objects) -> objects, o -> o);
    }

    public Object invokeStatic(Object ... params) {
        return this.invokeInstance(null, params);
    }

    public InvocationResult invokeStaticResulted(Object ... params) {
        return new InvocationResult(this.invokeStatic(params));
    }

    public Object invokeInstance(Object instance, Object ... params) {
        if (this.method == null) {
            return null;
        }
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        Object[] transformed = this.parameterTransformer.apply(this.method.getParameterTypes(), params);
        try {
            if (instance != null && Proxy.isProxyClass(instance.getClass())) {
                return this.resultTransformer.apply(Proxy.getInvocationHandler(instance).invoke(instance, this.method, transformed));
            }
            return this.resultTransformer.apply(this.method.invoke(instance, transformed));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public InvocationResult invokeInstanceResulted(Object instance, Object ... params) {
        return new InvocationResult(this.invokeInstance(instance, params));
    }

    public Object invokeInstance(InvocationHandler invocationHandler, Object proxiedObject, Object ... params) {
        if (this.method == null) {
            return null;
        }
        try {
            return this.resultTransformer.apply(invocationHandler.invoke(proxiedObject, this.method, this.parameterTransformer.apply(this.method.getParameterTypes(), params)));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public InvocationResult invokeInstanceResulted(InvocationHandler invocationHandler, Object proxiedObject, Object ... params) {
        return new InvocationResult(this.invokeInstance(invocationHandler, proxiedObject, params));
    }

    public ClassMethod withTransformer(BiFunction<Class<?>[], Object[], Object[]> parameterTransformer) {
        return new ClassMethod(this.method, parameterTransformer, this.resultTransformer);
    }

    public ClassMethod withTransformers(BiFunction<Class<?>[], Object[], Object[]> parameterTransformer, Function<Object, Object> resultTransformer) {
        return new ClassMethod(this.method, parameterTransformer, resultTransformer);
    }

    public ClassMethod withTransformer(Function<Object, Object> resultTransformer) {
        return new ClassMethod(this.method, this.parameterTransformer, resultTransformer);
    }

    @Override
    public ClassMethod self() {
        return this;
    }

    @Override
    @Nullable
    public Executable get() {
        return this.method;
    }

    public ClassMethod(Method method, BiFunction<Class<?>[], Object[], Object[]> parameterTransformer, Function<Object, Object> resultTransformer) {
        this.method = method;
        this.parameterTransformer = parameterTransformer;
        this.resultTransformer = resultTransformer;
    }

    public Method getMethod() {
        return this.method;
    }

    public BiFunction<Class<?>[], Object[], Object[]> getParameterTransformer() {
        return this.parameterTransformer;
    }

    public Function<Object, Object> getResultTransformer() {
        return this.resultTransformer;
    }
}

