/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.visuals;

import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.event.OnEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerLeaveEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerMoveEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerRespawnEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerTeleportEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerWorldChangeEvent;
import io.github.pronze.lib.screaminglib.packet.event.SPlayerServerboundInteractEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.InteractType;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPreDisable;
import io.github.pronze.lib.screaminglib.visuals.TouchableVisual;
import io.github.pronze.lib.screaminglib.visuals.Visual;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractVisualsManager<T extends TouchableVisual<T>> {
    protected final Map<UUID, T> activeVisuals = new ConcurrentHashMap<UUID, T>();
    private final Map<UUID, Long> coolDownMap = new HashMap<UUID, Long>();

    public void addVisual(UUID uuid, T visual) {
        this.activeVisuals.put(uuid, visual);
    }

    public void removeVisual(T visual) {
        this.removeVisual(visual.uuid());
    }

    public void removeVisual(UUID uuid) {
        this.activeVisuals.remove(uuid);
    }

    public Map<UUID, T> getActiveVisuals() {
        return Map.copyOf(this.activeVisuals);
    }

    @OnPreDisable
    public void destroy() {
        this.getActiveVisuals().values().forEach(Visual::destroy);
        this.activeVisuals.clear();
        this.coolDownMap.clear();
    }

    @OnEvent
    public void onLeave(SPlayerLeaveEvent event) {
        this.coolDownMap.remove(event.player().getUuid());
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        PlayerWrapper player = event.player();
        Iterator<Map.Entry<UUID, T>> iterator = this.activeVisuals.entrySet().iterator();
        while (iterator.hasNext()) {
            TouchableVisual visual = (TouchableVisual)iterator.next().getValue();
            if (visual.viewers().contains(player)) {
                visual.removeViewer(player);
            }
            if (visual.hasViewers()) continue;
            iterator.remove();
        }
    }

    @OnEvent
    public void onMove(SPlayerMoveEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        PlayerWrapper player = event.player();
        LocationHolder newLocation = event.newLocation();
        LocationHolder oldLocation = event.currentLocation();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            if (!visual.hasViewers()) continue;
            LocationHolder visualLocation = visual.location();
            int viewDistance = visual.viewDistance();
            if (!visual.viewers().contains(player) || !visualLocation.isWorldSame(newLocation)) continue;
            if (newLocation.isInRange(visualLocation, viewDistance) && oldLocation.outOfRange(visualLocation, viewDistance)) {
                visual.onViewerAdded(player, false);
                continue;
            }
            if (!newLocation.outOfRange(visualLocation, viewDistance) || !oldLocation.isInRange(visualLocation, viewDistance)) continue;
            visual.onViewerRemoved(player, false);
        }
    }

    @OnEvent
    public void onRespawn(SPlayerRespawnEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        PlayerWrapper player = event.player();
        LocationHolder respawnLocation = event.location();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            if (!visual.hasViewers()) continue;
            Collection<PlayerWrapper> viewers = visual.viewers();
            LocationHolder visualLocation = visual.location();
            int viewDistance = visual.viewDistance();
            if (!viewers.contains(player)) continue;
            if (!respawnLocation.isWorldSame(visualLocation)) {
                return;
            }
            if (!respawnLocation.isInRange(visualLocation, viewDistance)) continue;
            this.softAddViewer(visual, player, 20L);
        }
    }

    @OnEvent
    public void onWorldChange(SPlayerWorldChangeEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        PlayerWrapper player = event.player();
        WorldHolder from = event.from();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            if (!visual.hasViewers()) continue;
            Collection<PlayerWrapper> viewers = visual.viewers();
            LocationHolder visualLocation = visual.location();
            int viewDistance = visual.viewDistance();
            if (!viewers.contains(player) || !player.getLocation().isWorldSame(visualLocation) || from.equals(visualLocation.getWorld()) || !player.getLocation().isInRange(visualLocation, viewDistance)) continue;
            this.softAddViewer(visual, player, 1L);
        }
    }

    @OnEvent
    public void onTeleport(SPlayerTeleportEvent event) {
        LocationHolder newLocation;
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        LocationHolder currentLocation = event.currentLocation();
        if (!currentLocation.isWorldSame(newLocation = event.newLocation())) {
            return;
        }
        PlayerWrapper player = event.player();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            LocationHolder visualLocation;
            Collection<PlayerWrapper> viewers;
            if (!visual.hasViewers() || !(viewers = visual.viewers()).contains(player) || !(visualLocation = visual.location()).isWorldSame(player.getLocation())) continue;
            int viewDistance = visual.viewDistance();
            if (newLocation.isInRange(visualLocation, viewDistance) && currentLocation.outOfRange(visualLocation, viewDistance)) {
                this.softAddViewer(visual, player, 20L);
                continue;
            }
            if (!newLocation.outOfRange(visualLocation, viewDistance) || !currentLocation.isInRange(visualLocation, viewDistance)) continue;
            this.softRemoveViewer(visual, player, 20L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnEvent
    public void onInteract(SPlayerServerboundInteractEvent event) {
        PlayerWrapper player = event.getPlayer();
        int entityId = event.getEntityId();
        for (Map.Entry<UUID, T> entry : this.activeVisuals.entrySet()) {
            TouchableVisual visual = (TouchableVisual)entry.getValue();
            if (!visual.hasId(entityId) || !visual.touchable()) continue;
            Map<UUID, Long> map = this.coolDownMap;
            synchronized (map) {
                if (this.coolDownMap.containsKey(player.getUuid())) {
                    Long lastClick = this.coolDownMap.get(player.getUuid());
                    if (System.currentTimeMillis() - lastClick < visual.clickCooldown()) {
                        break;
                    }
                }
                this.coolDownMap.put(player.getUuid(), System.currentTimeMillis());
            }
            Server.runSynchronously(() -> this.fireVisualTouchEvent(player, visual, event.getInteractType()));
            break;
        }
    }

    private void softAddViewer(T visual, PlayerWrapper player, long tickedDelay) {
        Tasker.build(() -> {
            if (!player.isOnline()) {
                return;
            }
            visual.onViewerAdded(player, false);
        }).delay(tickedDelay, TaskerTime.TICKS).async().start();
    }

    private void softRemoveViewer(T visual, PlayerWrapper player, long tickedDelay) {
        Tasker.build(() -> {
            if (!player.isOnline()) {
                return;
            }
            visual.onViewerRemoved(player, false);
        }).delay(tickedDelay, TaskerTime.TICKS).async().start();
    }

    public abstract void fireVisualTouchEvent(PlayerWrapper var1, T var2, InteractType var3);
}

