/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.visuals.impl;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.utils.visual.TextEntry;
import io.github.pronze.lib.screaminglib.visuals.LinedVisual;
import io.github.pronze.lib.screaminglib.visuals.Visual;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractVisual;
import io.github.pronze.lib.screaminglib.visuals.utils.VisualUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;

public abstract class AbstractLinedVisual<T extends Visual<T>>
extends AbstractVisual<T>
implements LinedVisual<T> {
    protected ConcurrentSkipListMap<Integer, TextEntry> lines = new ConcurrentSkipListMap();
    protected Integer originalLinesSize = 0;

    public AbstractLinedVisual(UUID uuid) {
        super(uuid);
    }

    @Override
    public Map<Integer, TextEntry> lines() {
        return Map.copyOf(this.lines);
    }

    @Override
    public Optional<Map.Entry<Integer, TextEntry>> lineByIdentifier(String identifier) {
        return this.lines.entrySet().stream().filter(next -> ((TextEntry)next.getValue()).getIdentifier().equals(identifier)).map(next -> Map.entry((Integer)next.getKey(), (TextEntry)next.getValue())).findFirst();
    }

    @Override
    public T title(Component title) {
        return (T)this.firstLine(title);
    }

    @Override
    public T title(ComponentLike title) {
        return (T)this.firstLine(title);
    }

    @Override
    public T firstLine(Component text) {
        return (T)this.newLine((Integer)0, text);
    }

    @Override
    public T firstLine(ComponentLike text) {
        return (T)this.newLine((Integer)0, text);
    }

    @Override
    public T firstLine(TextEntry text) {
        return (T)this.newLine((Integer)0, text);
    }

    @Override
    public T bottomLine(Component text) {
        return (T)this.bottomLine(TextEntry.of(text));
    }

    @Override
    public T bottomLine(ComponentLike text) {
        return (T)this.bottomLine(TextEntry.of(text));
    }

    @Override
    public T bottomLine(TextEntry text) {
        if (this.lines.isEmpty()) {
            return (T)this.firstLine(text);
        }
        this.originalLinesSize = this.lines.size();
        this.lines.put(this.lines.lastKey() + 1, text);
        this.update();
        return (T)this;
    }

    @Override
    public T replaceLine(TextEntry text) {
        String identifier = text.getIdentifier();
        if (identifier.isEmpty()) {
            return (T)this.bottomLine(text);
        }
        Optional<Map.Entry<Integer, TextEntry>> line = this.lineByIdentifier(text.getIdentifier());
        if (line.isEmpty()) {
            return (T)this.bottomLine(text);
        }
        return (T)this.replaceLine(line.get().getKey(), text);
    }

    @Override
    public T replaceLine(Integer where, Component text) {
        return (T)this.replaceLine(where, TextEntry.of(text));
    }

    @Override
    public T replaceLine(Integer where, ComponentLike text) {
        return (T)this.replaceLine(where, TextEntry.of(text));
    }

    @Override
    public T replaceLine(Integer where, TextEntry text) {
        if (!this.lines.containsKey(where)) {
            return (T)this.newLine(where, text);
        }
        this.originalLinesSize = this.lines.size();
        this.lines.put(where, text);
        this.update();
        return (T)this;
    }

    @Override
    public T setLines(Map<Integer, TextEntry> lines) {
        this.originalLinesSize = this.lines.size();
        this.lines = new ConcurrentSkipListMap<Integer, TextEntry>(lines);
        this.update();
        return (T)this;
    }

    @Override
    public T setLines(List<Component> lines) {
        HashMap<Integer, TextEntry> toSet = new HashMap<Integer, TextEntry>();
        for (int i = 0; i < lines.size(); ++i) {
            toSet.put(i, TextEntry.of(lines.get(i)));
        }
        return (T)this.setLines(toSet);
    }

    @Override
    public T setLines(Set<TextEntry> lines) {
        List<TextEntry> ls = List.copyOf(lines);
        HashMap<Integer, TextEntry> toSet = new HashMap<Integer, TextEntry>();
        for (int i = 0; i < ls.size(); ++i) {
            toSet.put(i, ls.get(i));
        }
        return (T)this.setLines(toSet);
    }

    @Override
    public T newLine(Integer where, Component text) {
        return (T)this.newLine(where, TextEntry.of(text));
    }

    @Override
    public T newLine(Integer where, ComponentLike text) {
        return (T)this.newLine(where, TextEntry.of(text));
    }

    @Override
    public T newLine(Integer where, TextEntry text) {
        this.originalLinesSize = this.lines.size();
        this.lines = VisualUtils.addEntryAndMoveRest(this.lines, where, text);
        this.update();
        return (T)this;
    }

    @Override
    public T removeLine(Integer where) {
        this.originalLinesSize = this.lines.size();
        this.lines = VisualUtils.removeEntryAndMoveRest(this.lines, where);
        this.update();
        return (T)this;
    }

    @Override
    public T removeLine(String identifier) {
        this.lineByIdentifier(identifier).ifPresent(next -> {
            this.originalLinesSize = this.lines.size();
            this.lines = VisualUtils.removeEntryAndMoveRest(this.lines, (Integer)next.getKey());
            this.update();
        });
        return (T)this;
    }
}

