/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.visuals.impl;

import io.github.pronze.lib.screaminglib.visuals.LocatableVisual;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractVisual;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLocatableVisual<T extends LocatableVisual<T>>
extends AbstractVisual<T>
implements LocatableVisual<T> {
    private volatile boolean destroyed;
    private volatile int viewDistance;
    private volatile LocationHolder location;
    private volatile boolean created;

    public AbstractLocatableVisual(UUID uuid, LocationHolder location) {
        super(uuid);
        Objects.requireNonNull(location, "Location cannot be null!");
        this.viewDistance = 4096;
        this.destroyed = false;
        this.created = false;
        this.location = location;
    }

    @Override
    public int viewDistance() {
        return this.viewDistance;
    }

    @Override
    public T viewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        return (T)this;
    }

    @Override
    @NotNull
    public LocationHolder location() {
        return this.location;
    }

    @Override
    public T location(LocationHolder location) {
        Objects.requireNonNull(location, "Location cannot be null!");
        this.location = location;
        return (T)this;
    }

    @Override
    public T spawn() {
        if (this.created) {
            throw new UnsupportedOperationException("Visual: " + this.uuid.toString() + " is already spawned!");
        }
        this.created = true;
        return (T)this;
    }

    @Override
    public boolean created() {
        return this.created;
    }

    @Override
    public boolean destroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
    }
}

