/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.ProtoLocation;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.github.pronze.lib.screaminglib.world.WorldMapper;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class LocationMapper {
    protected BidirectionalConverter<LocationHolder> converter = BidirectionalConverter.build().registerP2W(LocationHolder.class, e -> e).registerW2P(BlockHolder.class, locationHolder -> BlockMapper.resolve(locationHolder).orElse(null));
    private static LocationMapper mapping;

    @ApiStatus.Internal
    public LocationMapper() {
        if (mapping != null) {
            throw new UnsupportedOperationException("LocationMapper is already initialized.");
        }
        mapping = this;
        if (Reflect.has("com.google.protobuf.MessageOrBuilder")) {
            this.converter.registerP2W(ProtoLocation.class, location -> {
                Optional<WorldHolder> world = WorldMapper.getWorld(UUID.fromString(location.getWorldUuid()));
                if (world.isEmpty()) {
                    return null;
                }
                return new LocationHolder(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), world.get());
            });
        }
    }

    public static Optional<LocationHolder> resolve(Object obj) {
        if (mapping == null) {
            throw new UnsupportedOperationException("LocationMapper is not initialized yet.");
        }
        return LocationMapper.mapping.converter.convertOptional(obj);
    }

    public static <T> LocationHolder wrapLocation(T input) {
        return LocationMapper.resolve(input).orElseThrow();
    }

    public static <T> T convert(LocationHolder holder, Class<T> newType) {
        if (mapping == null) {
            throw new UnsupportedOperationException("LocationMapper is not initialized yet.");
        }
        return LocationMapper.mapping.converter.convert(holder, newType);
    }
}

