/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pronze.lib.kyori.adventure.audience.ForwardingAudience;
import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.particle.ParticleHolder;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.WorldMapper;
import io.github.pronze.lib.screaminglib.world.chunk.ChunkHolder;
import io.github.pronze.lib.screaminglib.world.difficulty.DifficultyHolder;
import io.github.pronze.lib.screaminglib.world.dimension.DimensionHolder;
import io.github.pronze.lib.screaminglib.world.gamerule.GameRuleHolder;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public interface WorldHolder
extends Wrapper,
RawValueHolder,
Serializable,
ForwardingAudience {
    public UUID getUuid();

    public String getName();

    public int getMinY();

    public int getMaxY();

    public DifficultyHolder getDifficulty();

    public DimensionHolder getDimension();

    public Optional<ChunkHolder> getChunkAt(int var1, int var2);

    public Optional<ChunkHolder> getChunkAt(LocationHolder var1);

    public List<EntityBasic> getEntities();

    default public <T extends EntityBasic> List<T> getEntitiesByClass(Class<T> clazz) {
        return this.getEntities().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public <T> T getGameRuleValue(GameRuleHolder var1);

    public <T> void setGameRuleValue(GameRuleHolder var1, T var2);

    public long getTime();

    public void setTime(long var1);

    public void sendParticle(ParticleHolder var1, LocationHolder var2);

    public boolean isSpawnKeptInMemory();

    public boolean isSpawningOfAnimalsAllowed();

    public boolean isSpawningOfMonstersAllowed();

    public BlockHolder getHighestBlockAt(int var1, int var2);

    public int getHighestYAt(int var1, int var2);

    public static class WorldHolderTypeAdapter
    extends TypeAdapter<WorldHolder> {
        @Override
        public void write(JsonWriter out, WorldHolder value) throws IOException {
            out.beginObject();
            out.name("uuid");
            out.value(value.getUuid().toString());
            out.endObject();
        }

        @Override
        public WorldHolder read(JsonReader in) throws IOException {
            in.beginObject();
            String name = in.nextName();
            if (name.equals("uuid")) {
                WorldHolder toReturn = WorldMapper.getWorld(UUID.fromString(in.nextString())).orElseThrow();
                in.endObject();
                return toReturn;
            }
            throw new IOException("Name is not 'uuid'");
        }
    }
}

