/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.difficulty;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.DifficultyHolderSerializer;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import io.github.pronze.lib.screaminglib.world.difficulty.DifficultyHolder;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class DifficultyMapping
extends AbstractTypeMapper<DifficultyHolder> {
    private static DifficultyMapping difficultyMapping;
    protected final BidirectionalConverter<DifficultyHolder> difficultyConverter = BidirectionalConverter.build().registerP2W(DifficultyHolder.class, d -> d).registerP2W(ConfigurationNode.class, node -> {
        try {
            return DifficultyHolderSerializer.INSTANCE.deserialize((Type)((Object)DifficultyHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public DifficultyMapping() {
        if (difficultyMapping != null) {
            throw new UnsupportedOperationException("DifficultyMapping is already initialized!");
        }
        difficultyMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.DIFFICULTY)
    @OfMethodAlternative(value=DifficultyHolder.class, methodName="ofOptional")
    public static Optional<DifficultyHolder> resolve(Object difficulty) {
        if (difficultyMapping == null) {
            throw new UnsupportedOperationException("DifficultyMapping is not initialized yet.");
        }
        if (difficulty == null) {
            return Optional.empty();
        }
        return DifficultyMapping.difficultyMapping.difficultyConverter.convertOptional(difficulty).or(() -> difficultyMapping.resolveFromMapping(difficulty));
    }

    @OfMethodAlternative(value=DifficultyHolder.class, methodName="all")
    public static List<DifficultyHolder> getValues() {
        if (difficultyMapping == null) {
            throw new UnsupportedOperationException("DifficultyMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(DifficultyMapping.difficultyMapping.values);
    }
}

