/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.dimension;

import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.world.dimension.DimensionMapping;
import java.util.List;
import java.util.Optional;

public interface DimensionHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.DIMENSION)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.DIMENSION)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.DIMENSION)
    public static DimensionHolder of(Object dimension) {
        return DimensionHolder.ofOptional(dimension).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.DIMENSION)
    public static Optional<DimensionHolder> ofOptional(Object dimension) {
        if (dimension instanceof DimensionHolder) {
            return Optional.of((DimensionHolder)dimension);
        }
        return DimensionMapping.resolve(dimension);
    }

    public static List<DimensionHolder> all() {
        return DimensionMapping.getValues();
    }
}

