/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories;

import io.github.pronze.lib.screaminglib.Core;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import io.github.pronze.lib.simpleinventories.builder.InventorySetBuilder;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.placeholders.IPlaceholderParser;
import io.github.pronze.lib.simpleinventories.render.InventoryRenderer;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<className>.+)Core$", replaceRule="{basePackage}.{platform}.{className}{Platform}")
@ServiceDependencies(dependsOn={Core.class, Tasker.class})
public abstract class SimpleInventoriesCore {
    protected Logger logger;
    protected static SimpleInventoriesCore core;

    protected SimpleInventoriesCore(Logger logger) {
        if (core != null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore is already initialized.");
        }
        core = this;
        this.logger = logger;
    }

    public static InventoryRenderer openInventory(PlayerWrapper playerWrapper, SubInventory subInventory) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        InventoryRenderer renderer = core.openInventory0(playerWrapper, subInventory);
        renderer.render();
        return renderer;
    }

    protected abstract InventoryRenderer openInventory0(PlayerWrapper var1, SubInventory var2);

    public static Logger getLogger() {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return SimpleInventoriesCore.core.logger;
    }

    public static Optional<InventoryRenderer> getInventoryRenderer(PlayerWrapper playerWrapper) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return Optional.ofNullable(core.getInventoryRenderer0(playerWrapper));
    }

    protected abstract InventoryRenderer getInventoryRenderer0(PlayerWrapper var1);

    public static List<InventoryRenderer> getAllInventoryRenderersForSubInventory(SubInventory subInventory) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.getAllInventoryRenderersForSubInventory0(subInventory);
    }

    protected abstract List<InventoryRenderer> getAllInventoryRenderersForSubInventory0(SubInventory var1);

    public static List<InventoryRenderer> getAllInventoryRenderersForInventorySet(InventorySet inventorySet) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.getAllInventoryRenderersForInventorySet0(inventorySet);
    }

    protected abstract List<InventoryRenderer> getAllInventoryRenderersForInventorySet0(InventorySet var1);

    public static Object readConfigurationSerializable(Map<String, Object> configuration) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.readConfigurationSerializable0(configuration);
    }

    protected abstract Object readConfigurationSerializable0(Map<String, Object> var1);

    public static void registerPlatformSpecificPlaceholders(Map<String, IPlaceholderParser> placeholders) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        core.registerPlatformSpecificPlaceholders0(placeholders);
    }

    protected abstract void registerPlatformSpecificPlaceholders0(Map<String, IPlaceholderParser> var1);

    public static void runJar(File file) throws Exception {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        core.runJar0(file);
    }

    protected abstract void runJar0(File var1) throws Exception;

    public static Path getRootPath() {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.getRootPath0();
    }

    protected abstract Path getRootPath0();

    public static InventorySetBuilder builder() {
        return InventorySetBuilder.of(new InventorySet());
    }
}

