/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.builder;

import io.github.pronze.lib.simpleinventories.builder.AbstractQueueBuilder;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.Queueable;
import io.github.pronze.lib.simpleinventories.inventory.SubInventoryLike;
import lombok.NonNull;

public final class QueueBuilder
extends AbstractQueueBuilder<QueueBuilder> {
    private final InventorySet format;
    private final SubInventoryLike<?> queue;

    @Override
    protected void putObjectToQueue(@NonNull Queueable queueable) {
        if (queueable == null) {
            throw new NullPointerException("queueable is marked non-null but is null");
        }
        this.queue.putIntoQueue(queueable);
    }

    @Override
    public InventorySet getFormat() {
        return this.format;
    }

    public SubInventoryLike<?> getQueue() {
        return this.queue;
    }

    private QueueBuilder(InventorySet format, SubInventoryLike<?> queue) {
        this.format = format;
        this.queue = queue;
    }

    public static QueueBuilder of(InventorySet format, SubInventoryLike<?> queue) {
        return new QueueBuilder(format, queue);
    }
}

