/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.bukkit;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnEnable;
import io.github.pronze.lib.simpleinventories.SimpleInventoriesCore;
import io.github.pronze.lib.simpleinventories.bukkit.action.BukkitClickActionHandler;
import io.github.pronze.lib.simpleinventories.bukkit.action.BukkitCloseInventoryActionHandler;
import io.github.pronze.lib.simpleinventories.bukkit.action.BukkitItemDragActionHandler;
import io.github.pronze.lib.simpleinventories.bukkit.action.BukkitItemMoveActionHandler;
import io.github.pronze.lib.simpleinventories.bukkit.holder.AbstractHolder;
import io.github.pronze.lib.simpleinventories.bukkit.placeholders.PAPIPlaceholderParser;
import io.github.pronze.lib.simpleinventories.bukkit.placeholders.PermissionPlaceholderParser;
import io.github.pronze.lib.simpleinventories.bukkit.placeholders.PlayerPlaceholderParser;
import io.github.pronze.lib.simpleinventories.bukkit.placeholders.WorldPlaceholderParser;
import io.github.pronze.lib.simpleinventories.bukkit.render.BukkitInventoryRenderer;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.placeholders.IPlaceholderParser;
import io.github.pronze.lib.simpleinventories.render.InventoryRenderer;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

@Service
public class SimpleInventoriesBukkit
extends SimpleInventoriesCore {
    private final Plugin plugin;

    public SimpleInventoriesBukkit(Plugin plugin) {
        super(plugin.getLogger());
        this.plugin = plugin;
    }

    @OnEnable
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitClickActionHandler(), this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitCloseInventoryActionHandler(), this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitItemDragActionHandler(), this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitItemMoveActionHandler(), this.plugin);
    }

    public static Plugin getPlugin() {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return ((SimpleInventoriesBukkit)SimpleInventoriesBukkit.core).plugin;
    }

    @Override
    protected BukkitInventoryRenderer openInventory0(PlayerWrapper playerWrapper, SubInventory subInventory) {
        return new BukkitInventoryRenderer(playerWrapper, subInventory, 0);
    }

    @Override
    protected InventoryRenderer getInventoryRenderer0(PlayerWrapper playerWrapper) {
        Player player = playerWrapper.as(Player.class);
        if (player != null) {
            return this.getInventoryRenderer0(player);
        }
        return null;
    }

    protected InventoryRenderer getInventoryRenderer0(Player player) {
        Inventory top = player.getOpenInventory().getTopInventory();
        if (top.getHolder() instanceof AbstractHolder) {
            return ((AbstractHolder)top.getHolder()).getInventoryRenderer();
        }
        return null;
    }

    @Override
    protected List<InventoryRenderer> getAllInventoryRenderersForSubInventory0(SubInventory subInventory) {
        return Bukkit.getOnlinePlayers().stream().map(this::getInventoryRenderer0).filter(Objects::nonNull).filter(inventoryRenderer -> inventoryRenderer.getSubInventory() == subInventory).collect(Collectors.toList());
    }

    @Override
    protected List<InventoryRenderer> getAllInventoryRenderersForInventorySet0(InventorySet inventorySet) {
        return Bukkit.getOnlinePlayers().stream().map(this::getInventoryRenderer0).filter(Objects::nonNull).filter(inventoryRenderer -> inventoryRenderer.getSubInventory().getInventorySet() == inventorySet).collect(Collectors.toList());
    }

    @Override
    protected Object readConfigurationSerializable0(Map<String, Object> configuration) {
        try {
            return ConfigurationSerialization.deserializeObject(configuration);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return configuration;
        }
    }

    @Override
    protected void registerPlatformSpecificPlaceholders0(Map<String, IPlaceholderParser> placeholders) {
        placeholders.put("papi", new PAPIPlaceholderParser());
        placeholders.put("world", new WorldPlaceholderParser());
        placeholders.put("player", new PlayerPlaceholderParser());
        placeholders.put("permission", new PermissionPlaceholderParser());
    }

    @Override
    protected void runJar0(File file) throws Exception {
        Plugin plugin = Bukkit.getPluginManager().loadPlugin(file);
        Bukkit.getPluginManager().enablePlugin(plugin);
    }

    @Override
    protected Path getRootPath0() {
        return this.plugin.getDataFolder().toPath();
    }
}

