/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.bukkit.placeholders;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.placeholders.IPlaceholderParser;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldPlaceholderParser
implements IPlaceholderParser {
    @Override
    public String processPlaceholder(String key, PlayerWrapper player, PlayerItemInfo item, String[] arguments) {
        World world = player.as(Player.class).getWorld();
        if (arguments.length >= 1) {
            switch (arguments[0]) {
                case "time": {
                    return Long.toString(world.getTime());
                }
                case "difficulty": {
                    return world.getDifficulty().name();
                }
                case "type": 
                case "environment": {
                    return world.getEnvironment().name();
                }
                case "weather": {
                    return world.getWorldType().name();
                }
                case "pvp": 
                case "ispvp": {
                    return Boolean.toString(world.getPVP());
                }
            }
        }
        return world.getName();
    }
}

