/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.events;

import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.ReceiverConsumer;
import io.github.pronze.lib.simpleinventories.builder.AnimationBuilder;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;

public class ItemRenderEvent
implements SEvent {
    private final PlayerItemInfo item;

    public InventorySet getFormat() {
        return this.item.getFormat();
    }

    public PlayerItemInfo getInfo() {
        return this.item;
    }

    public GenericItemInfo getOriginalInfo() {
        return this.item.getOriginal();
    }

    public Item getStack() {
        return this.item.getStack();
    }

    public void setStack(Item stack) {
        this.item.setStack(stack);
    }

    public boolean isVisible() {
        return this.item.isVisible();
    }

    public void setVisible(boolean visible) {
        this.item.setVisible(visible);
    }

    public boolean isDisabled() {
        return this.item.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.item.setDisabled(disabled);
    }

    public ItemRenderEvent disabled(boolean disabled) {
        this.setDisabled(disabled);
        return this;
    }

    public ItemRenderEvent visible(boolean visible) {
        this.setVisible(visible);
        return this;
    }

    public AnimationBuilder getAnimation() {
        return AnimationBuilder.of(this.item.getAnimation());
    }

    public ItemRenderEvent animation(ReceiverConsumer<AnimationBuilder> consumer) {
        consumer.accept(this.getAnimation());
        return this;
    }

    public ItemRenderEvent stack(ReceiverConsumer<ItemBuilder> consumer) {
        ItemBuilder builder = this.item.getStack().builder();
        consumer.accept(builder);
        this.item.setStack(builder.build().orElse(ItemFactory.getAir()));
        return this;
    }

    public ItemRenderEvent clearStack(ReceiverConsumer<ItemBuilder> consumer) {
        ItemBuilder builder = ItemFactory.builder();
        consumer.accept(builder);
        this.item.setStack(builder.build().orElse(ItemFactory.getAir()));
        return this;
    }

    public String process(String raw) {
        return this.item.getFormat().processPlaceholders(this.item.getPlayer(), raw, this.item);
    }

    public PlayerWrapper getPlayer() {
        return this.item.getPlayer();
    }

    public ItemRenderEvent player(ReceiverConsumer<PlayerWrapper> consumer) {
        consumer.accept(this.getPlayer());
        return this;
    }

    public PlayerItemInfo getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemRenderEvent)) {
            return false;
        }
        ItemRenderEvent other = (ItemRenderEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerItemInfo this$item = this.getItem();
        PlayerItemInfo other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemRenderEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerItemInfo $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public String toString() {
        return "ItemRenderEvent(item=" + this.getItem() + ")";
    }

    public ItemRenderEvent(PlayerItemInfo item) {
        this.item = item;
    }
}

