/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.configurate.gson.GsonConfigurationLoader;
import io.github.pronze.lib.configurate.hocon.HoconConfigurationLoader;
import io.github.pronze.lib.configurate.xml.XmlConfigurationLoader;
import io.github.pronze.lib.configurate.yaml.YamlConfigurationLoader;
import io.github.pronze.lib.simpleinventories.SimpleInventoriesCore;
import io.github.pronze.lib.simpleinventories.inventory.Queueable;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.loaders.ConfigurateLoader;
import io.github.pronze.lib.simpleinventories.loaders.CsvLoader;
import io.github.pronze.lib.simpleinventories.loaders.GroovyLoader;
import io.github.pronze.lib.simpleinventories.loaders.ILoader;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Include
implements Queueable {
    public static final Pattern INCLUDE_PATTERN = Pattern.compile("^((?<loader>[A-Za-z0-9]*)(:(?<section>[A-Za-z0-9.]*))?@)?(?<path>.+)$");
    public static final Map<String, Supplier<? extends ILoader>> LOADERS = Map.ofEntries(Map.entry("yml", () -> ConfigurateLoader.of(YamlConfigurationLoader::builder)), Map.entry("yaml", () -> ConfigurateLoader.of(YamlConfigurationLoader::builder)), Map.entry("json", () -> ConfigurateLoader.of(GsonConfigurationLoader::builder)), Map.entry("xml", () -> ConfigurateLoader.of(XmlConfigurationLoader::builder)), Map.entry("conf", () -> ConfigurateLoader.of(HoconConfigurationLoader::builder)), Map.entry("hocon", () -> ConfigurateLoader.of(HoconConfigurationLoader::builder)), Map.entry("groovy", GroovyLoader::new), Map.entry("gvy", GroovyLoader::new), Map.entry("gy", GroovyLoader::new), Map.entry("gsh", GroovyLoader::new), Map.entry("csv", CsvLoader::new), Map.entry("txt", CsvLoader::new));
    private final Path path;
    private final ILoader loader;
    private final String section;

    public static Include of(String link) {
        return Include.ofSection(link, "data");
    }

    public static Include ofSection(String link, String defaultSection) {
        Matcher matcher = INCLUDE_PATTERN.matcher(link.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("String " + link + " doesn't match pattern " + INCLUDE_PATTERN.pattern());
        }
        String loader = matcher.group("loader");
        String section = matcher.group("section");
        String pathString = matcher.group("path");
        Path path = Path.of(pathString, new String[0]);
        if (loader == null || loader.isEmpty()) {
            String filename = path.getFileName().toString();
            loader = filename.substring(filename.lastIndexOf(46) + 1);
        }
        if (section == null || section.isEmpty()) {
            section = defaultSection;
        }
        return Include.of(link, loader, section);
    }

    public static Include of(File file) {
        return Include.of(file.toPath());
    }

    public static Include of(Path path) {
        String filename = path.getFileName().toString();
        String loader = filename.substring(filename.lastIndexOf(46) + 1);
        return Include.of(path, loader);
    }

    public static Include of(String fileName, String loader) {
        return Include.of(Path.of(fileName, new String[0]), loader);
    }

    public static Include of(String fileName, ILoader loader) {
        return Include.of(Path.of(fileName, new String[0]), loader);
    }

    public static Include of(File file, String loader) {
        return Include.of(file.toPath(), loader);
    }

    public static Include of(File file, ILoader loader) {
        return Include.of(file.toPath(), loader);
    }

    public static Include of(Path path, String loader) {
        return Include.of(path, loader, "data");
    }

    public static Include of(Path path, ILoader loader) {
        return Include.of(path, loader, "data");
    }

    public static Include of(String fileName, String loader, String section) {
        return Include.of(Path.of(fileName, new String[0]), loader, section);
    }

    public static Include of(String fileName, ILoader loader, String section) {
        return Include.of(Path.of(fileName, new String[0]), loader, section);
    }

    public static Include of(File file, String loader, String section) {
        return Include.of(file.toPath(), loader, section);
    }

    public static Include of(File file, ILoader loader, String section) {
        return Include.of(file.toPath(), loader, section);
    }

    public static Include of(Path path, String loader, String section) {
        return Include.of(path, LOADERS.getOrDefault(loader.toLowerCase(), () -> ConfigurateLoader.of(YamlConfigurationLoader::builder)).get(), section);
    }

    public static Include of(Path path, ILoader loader, String section) {
        if (!path.isAbsolute()) {
            path = SimpleInventoriesCore.getRootPath().resolve(path);
        }
        return new Include(path, loader, section);
    }

    public void apply(SubInventory subInventory) {
        try {
            this.loader.loadPathInto(subInventory, this.path, this.section);
        }
        catch (Exception e) {
            SimpleInventoriesCore.getLogger().severe("An error occurred while including file to inventory: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Path getPath() {
        return this.path;
    }

    public ILoader getLoader() {
        return this.loader;
    }

    public String getSection() {
        return this.section;
    }

    private Include(Path path, ILoader loader, String section) {
        this.path = path;
        this.loader = loader;
        this.section = section;
    }
}

